/********************************************************************
 * Copyright (c) 2021 by SK karoly.saly@matrasoft.hu				*
 *																	*
  * s7comtest - s7ct_vat.c											*
********************************************************************/
#include "s7comtest.h"
#define MAX_VATFILESIZE				65536
#define STR_PLC			"PLC"
#define STR_VAR			"Var"
#define STR_INTERFACE	"IF"
#define STR_ADDRESS		"Address"
#define STR_RACK		"Rack"
#define STR_SLOT		"Slot"
#define STR_VARCOUNT	"VarCount"
#define STR_VIEW		"View"

#ifdef LANGUAGE_ENGLISH
#define LSFD_FILTER		"Variable Table (*.vat)\0*.vat\0"
#define SFD_TITLE		"Save Variable Table"
#define LFD_TITLE		"Load Variable Table"
#endif
#ifdef LANGUAGE_HUNGARIAN
#define LSFD_FILTER		"Vltoz tbla (*.vat)\0*.vat\0"
#define SFD_TITLE		"Vltoz tbla mentse"
#define LFD_TITLE		"Vltoz tbla betltse"
#endif

#define SFD_FLAGS		OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST | OFN_NOREADONLYRETURN | OFN_HIDEREADONLY | OFN_ENABLESIZING
#define LFD_OPENFLAGS	OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING

#pragma pack(push, 1)

typedef struct tagMODEINFO {
	INT32						nOldMode;
	INT32						nNewMode;
	INT32						nOldAddr;
	INT32						nNewAddr;
	char						cOldName[S7MAX_NAMESIZE];
	char						cNewName[S7MAX_NAMESIZE];
} MODEINFO, *LPMODEINFO;

#pragma pack(pop)

static INT32		m_nLastMode		= 0;
static LPMODEINFO	m_pInfo			= NULL;
// **********************************************************************************
static void pButtonText(LPSTR lpDst, LPSTR lpMsg, LPSTR lpName, INT32 nMode, INT32 nAddr) {
char	cAddr[32];

	StrPrint(cAddr, nMode == IFM_TCP ? "%a" : "%d", nAddr);
	StrPrint(lpDst, "%s : %s - %s %[(%s)%]", lpMsg, g_pIFMode[nMode], cAddr, lpName, lpName[0]);
}
// **********************************************************************************
static INT32 CALLBACK pModeSelect(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
INT32				nID, nCmd;
char				cBuf[256];

	switch (uMsg) {
	case WM_INITDIALOG:
#ifdef LANGUAGE_ENGLISH
		pButtonText(cBuf, "Use the current PLC", m_pInfo->cOldName, m_pInfo->nOldMode, m_pInfo->nOldAddr);
#endif
#ifdef LANGUAGE_HUNGARIAN
		pButtonText(cBuf, "Jelenlegi PLC hasznlata", m_pInfo->cOldName, m_pInfo->nOldMode, m_pInfo->nOldAddr);
#endif
		SendDlgItemMessage(hDlg, IDC_LOAD_USEOLD, WM_SETTEXT, 0, (LPARAM) cBuf);
#ifdef LANGUAGE_ENGLISH
		pButtonText(cBuf, "Use the saved PLC", m_pInfo->cNewName, m_pInfo->nNewMode, m_pInfo->nNewAddr);
#endif
#ifdef LANGUAGE_HUNGARIAN
		pButtonText(cBuf, "Mentett PLC hasznlata", m_pInfo->cNewName, m_pInfo->nNewMode, m_pInfo->nNewAddr);
#endif
		SendDlgItemMessage(hDlg, IDC_LOAD_USENEW, WM_SETTEXT, 0, (LPARAM) cBuf);
		CheckDlgButton(hDlg, IDC_LOAD_USEOLD + m_nLastMode, BST_CHECKED);
		CenterWindow(hDlg, g_hWndMain);
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		return TRUE;
	case WM_COMMAND:
		nID = LOWORD(wParam);
		nCmd = HIWORD(wParam);
		switch (nID) {
		case IDOK:
			EndDialog (hDlg, IDOK);
			return TRUE ;
		case IDCANCEL:
			EndDialog (hDlg, 0);
			return TRUE ;
		case IDC_LOAD_USEOLD:
		case IDC_LOAD_USENEW:
			switch (nCmd) {
			case BN_CLICKED:
				m_nLastMode = nID - IDC_IF_TCP;
				break;
			}
			return TRUE;
		} // end switch
		return TRUE ;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if (wParam == IDC_SEPARATOR) {
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		return TRUE ;
	} // end switch
	return FALSE ;
}
// **********************************************************************************
LPVATDATA __stdcall VAT_Init(LPVATDATA lpVat) {

	if (lpVat) {
		MemClr(lpVat, sizeof(VATDATA));
	}
	else {
		lpVat = GetMem(GMM_CLEAR, sizeof(VATDATA));
	}
//	lpVat->nIFMode = IFM_TCP;
	lpVat->nAddr = DEFAULT_IP;
//	lpVat->nRack = 0;
	lpVat->nSlot = 2;
//	lpVat->nVarCnt = 0;
	lpVat->nTimeOut = 1000;
	return lpVat;
}
// **********************************************************************************
LPVATDATA __stdcall VAT_Done(LPVATDATA lpVat, BOOL bCloseIF, BOOL bCloseCon, BOOL bLog, BOOL bFree) {
INT32	i;

	if (bCloseCon && lpVat->hCon) {
		lpVat->hCon = S7_Connection_Done(lpVat->hCon);
		if (bLog) WriteMsg(IDS_CON_DONE, 0, NULL);
	}
	if (bCloseIF && lpVat->hIF) {
		lpVat->hIF = S7_Interface_Done(lpVat->hIF);
		if (bLog) WriteMsg(IDS_IF_DONE, 0, NULL);
	}
	for (i = 0; i < lpVat->nVarCnt; i++) {
		FreeMem(lpVat->VarInfo[i].pData);
	}
	if (bFree) {
		FreeMem(lpVat);
		lpVat = NULL;
	}
	else {
		MemClr(&lpVat->VarInfo, sizeof(lpVat->VarInfo));
		MemClr(lpVat->cPlcName, S7MAX_NAMESIZE);
		lpVat->nVarCnt = 0;
	}
	return lpVat;
}
// **********************************************************************************
static void __stdcall pWriteVatMsg(LPSTR lpFileName, LPSTR lpBuf, LPSTR lpSect, LPSTR lpPar) {
char			cFile[MAX_PATH], cBuf[2056], cParam[1024];
INT32			nLen;

	FSplit(FALSE, NULL, cFile, lpFileName);
	nLen = GetIniBufStr(lpBuf, lpSect, lpPar, cParam, sizeof(cParam), NULL);
	nLen = StrPrint(cBuf, "%s line in %s at section %s\r\n%s = %s\r\n", nLen ? "Invalid" : "Missing", cFile, lpSect, lpPar, cParam);
	EditWin_Write(g_pMainEdit, cBuf, nLen, TRUE);
}
// **********************************************************************************
static void __stdcall pWriteIOMsg(LPSTR lpFileName, LPSTR lpTitle, LPSTR lpMsg) {
char			cFile[MAX_PATH], cBuf[2056];
INT32			nLen;

	FSplit(FALSE, NULL, cFile, lpFileName);
	nLen = StrPrint(cBuf, "%s : %s - %s. :-(\r\n", lpTitle, cFile, lpMsg);
	EditWin_Write(g_pMainEdit, cBuf, nLen, TRUE);
}
// **********************************************************************************
static void __stdcall pCheckFileName(LPSTR lpFileName) {

	if (!lpFileName[0]) {
		FSplit(TRUE, lpFileName, NULL, g_cProgName);
		StrCat(lpFileName, "*.vat");
	}
}
// **********************************************************************************
BOOL __stdcall Save_VAT(LPSTR lpFileName, LPVATDATA lpVat) {
char		cFile[MAX_PATH], cFolder[MAX_PATH];
char		cBuf[256], cSect[16], cPar[16];
LPSTR		pBuf, pName;
LPFILEIO	pFile;
UINT32		nSize, dwWritten, j;
INT32		i;
BOOL		bRet;

	pCheckFileName(lpFileName);
	bRet = FALSE;
	FSplit(FALSE, cFolder, NULL, lpFileName);
	StrCpy(cFile, lpFileName);
	if (SaveFileDlg(g_hWndMain, SFD_TITLE, cFile, cFolder, LSFD_FILTER, STR_EXT_VAT, SFD_FLAGS, LVCMD_DEFAULT, NULL)) {
		StrCpy(lpFileName, cFile);
		pBuf = GetMem(GMM_CLEAR, MAX_VATFILESIZE);
		nSize = SetIniBufStr(&pBuf, STR_PLC, STR_INTERFACE, g_pIFMode[lpVat->nIFMode]);
		nSize = SetIniBufStr(&pBuf, STR_PLC, STR_NAME, lpVat->cPlcName);
		StrPrint(cBuf, (lpVat->nIFMode == IFM_TCP) ? "%a" : "%d", lpVat->nAddr);
		nSize = SetIniBufStr(&pBuf, STR_PLC, STR_ADDRESS, cBuf);
		nSize = SetIniBufInt(&pBuf, STR_PLC, STR_TIMEOUT, lpVat->nTimeOut);
		nSize = SetIniBufInt(&pBuf, STR_PLC, STR_RACK, lpVat->nRack);
		nSize = SetIniBufInt(&pBuf, STR_PLC, STR_SLOT, lpVat->nSlot);
		nSize = SetIniBufInt(&pBuf, STR_PLC, STR_VARCOUNT, lpVat->nVarCnt);
		for (i = 0; i < lpVat->nVarCnt; i++) {
			StrPrint(cSect, "%s%d", STR_VAR, i);
			GetVarName(FALSE, TRUE, TRUE, 0, &lpVat->VarInfo[i], cBuf, NULL);
			nSize = SetIniBufStr(&pBuf, cSect, STR_VAR, cBuf);
			pName = lpVat->VarInfo[i].pName;
			for (j = 0; j < lpVat->VarInfo[i].nCount; j++) {
				if (pName[0]) {
					StrPrint(cPar, "%s%d", STR_NAME, j);
					nSize = SetIniBufStr(&pBuf, cSect, cPar, pName);
				}
				if (lpVat->VarInfo[i].pView[j]) {
					StrPrint(cPar, "%s%d", STR_VIEW, j);
					LoadString(g_hResource, IDM_VM_FIRST + lpVat->VarInfo[i].pView[j], cBuf, sizeof(cBuf));
					nSize = SetIniBufStr(&pBuf, cSect, cPar, cBuf);
				}
				pName += S7MAX_NAMESIZE;
			}
		}
		pFile = FOpen(cFile, FOM_REWRITE, NULL);
		dwWritten = FWrite(pFile, pBuf, nSize);
		FClose(pFile);
		FreeMem(pBuf);
		FSplit(FALSE, cFolder, cFile, lpFileName);
		if (nSize != dwWritten) {
			pWriteIOMsg(cFile, SFD_TITLE, "can't save");
		}
		bRet = TRUE;
	}
	return bRet;
}
// **********************************************************************************
static BOOL __stdcall pGetVarInfo(LPSTR lpBuf, LPVARINFO lpVI) {
VARINFO		VI;
char		cBuf[256];
LPSTR		pStr;
INT32		i, nLen, nScan, nSizeIdx;

	nLen = TrimCpy(cBuf, lpBuf, TSM_BOTH);
	if (!nLen) return FALSE;
	StrUpr(cBuf);
	pStr = cBuf;
	MemClr(&VI, sizeof(VARINFO));
	VI.nArea = nSizeIdx = -1; 
	for (i = 0; i < S7AT_MAX; i++) {
		if (g_cAreaName[i] == cBuf[0]) {
			VI.nArea = i;
			break;
		}
	}
	if (VI.nArea < 0) return FALSE;
	nLen--;
	pStr++;
	switch (VI.nArea) {
	case S7AT_DB:
		if (!nLen || (*pStr != 'B')) return FALSE;
		nLen--;
		pStr++;
		VI.nDB = (INT32) IntVal(pStr, NF_UDEC, 0, &nScan);
		if ((VI.nDB <= 0) || (VI.nDB > MAX_DBNUM)) return FALSE;
		pStr += nScan;
		nLen -= nScan;
		if ((nLen < 4) || (*pStr != '.') || (pStr[1] != 'D') || (pStr[2] != 'B')) return FALSE;
		for (i = 0; i < MAX_SIZENAME; i++) {
			if (g_cSizeName[i] == pStr[3]) {
				nSizeIdx = i;
				break;
			}
		}
		pStr += 4;
		nLen -= 4;
		break;
	case S7AT_TIMER:
	case S7AT_COUNTER:
		nSizeIdx = 2;
		break;
	default:
		for (i = 1; i < MAX_SIZENAME; i++) {
			if (g_cSizeName[i] == *pStr) {
				nSizeIdx = i;
				pStr++;
				nLen--;
				break;
			}
		}
		if ((nSizeIdx == -1) && (*pStr >= '0') && (*pStr <= '9')) nSizeIdx = 0;
	}
	if (!nLen || (nSizeIdx < 0)) return FALSE;
	VI.nAddr = (INT32) IntVal(pStr, NF_UDEC, 0, &nScan);
	if ((nScan <= 0) || (VI.nAddr < 0) || (VI.nAddr > MAX_ADDRESS)) return FALSE;
	nLen -= nScan;
	pStr += nScan;
	if (nSizeIdx == 0) {
		if ((nLen < 2) || (*pStr != '.') || (pStr[1] < '0') || (pStr[1] > '7')) return FALSE;
		VI.nBit = pStr[1] - '0';
		nLen -= 2;
		pStr += 2;
	}
	while (nLen && (*pStr == ' ')) {
		pStr++;
		nLen--;
	}
	if (!nLen || (*pStr != ':')) return FALSE;
	pStr++;
	nLen--;
	if (!nLen) return FALSE;
	VI.nCount = (INT32) IntVal(pStr, NF_UDEC, 0, &nScan);
	if ((nScan <= 0) || (VI.nCount < 0) || (VI.nCount > 512)) return FALSE;
	nLen -= nScan;
	pStr += nScan;
	while (nLen && (*pStr == ' ')) {
		nLen--;
		pStr++;
	}
	if (!nLen || (*pStr != '(') || (pStr[nLen - 1] != ')')) return FALSE;
	pStr[nLen - 1] = 0;
	nLen = TrimCpy(cBuf, &pStr[1], TSM_BOTH);
	VI.nVT = -1;
	for (i = 0; i < S7VT_MAX; i++) {
		if (StrICmp(g_VarTypes[i], cBuf) == 0) {
			VI.nVT = i;
			break;
		}
	}
	if (VI.nVT < 0) return FALSE;
	PresetVarInfo(TRUE, VI.nVT, VI.nArea, VI.nCount, lpVI);
	switch (nSizeIdx) {
	case 0:
		VI.nPlcVarSize = 1;
		break;
	case 1:
	case 2:
		VI.nPlcVarSize = nSizeIdx;
		break;
	default:
		VI.nPlcVarSize = 1 << (nSizeIdx -1);
	}
	if (((nSizeIdx == 0) && (VI.nVT != S7VT_BIT)) || (VI.nPlcVarSize != lpVI->nPlcVarSize)) return FALSE;
	if ((VI.nVT == S7VT_BIT) && (VI.nCount > 1) && (VI.nBit || (VI.nCount & 7))) return FALSE;
	lpVI->nDB = VI.nDB;
	lpVI->nAddr = VI.nAddr;
	lpVI->nBit = VI.nBit;
	lpVI->pData = GetMem(GMM_CLEAR, VI.nCount * (1 + S7MAX_NAMESIZE) + (lpVI->nAllocSize << 1));
	lpVI->pView = lpVI->pData + (lpVI->nAllocSize << 1);
	lpVI->pName = lpVI->pView + VI.nCount;
	return TRUE;
}
// **********************************************************************************
static BOOL __stdcall pRead_VAT(LPSTR lpFileName, LPSTR lpBuf, LPVATDATA lpVat) {
char		cBuf[256], cSect[16], cPar[16], cView[32];
LPSTR		pName;
UINT32		j;
INT32		i, k, nLen, nViewModeCnt;
INT32		nViewModeList[VM_MAX];

	GetIniBufStr(lpBuf, STR_PLC, STR_INTERFACE, cBuf, sizeof(cBuf), NULL);
	lpVat->nIFMode = IFM_UNKNOWN;
	for (i = 0; i < IFM_MAX; i++) {
		if (StrICmp(cBuf, g_pIFMode[i]) == 0) {
			lpVat->nIFMode = i;
			break;
		}
	}
	if (lpVat->nIFMode == IFM_UNKNOWN) {
		pWriteVatMsg(lpFileName, lpBuf, STR_PLC, STR_INTERFACE);
		return FALSE;
	}
	nLen = GetIniBufStr(lpBuf, STR_PLC, STR_NAME, lpVat->cPlcName, sizeof(lpVat->cPlcName), NULL);
	if (lpVat->nIFMode == IFM_TCP) {
		lpVat->nAddr = GetIniBufIP(lpBuf, STR_PLC, STR_ADDRESS, -1);
	}
	else {
		lpVat->nAddr = GetIniBufInt(lpBuf, STR_PLC, STR_ADDRESS, 0, 127, -1);
	}
	if (lpVat->nAddr == -1) {
		pWriteVatMsg(lpFileName, lpBuf, STR_PLC, STR_ADDRESS);
		return FALSE;
	}
	lpVat->nTimeOut = GetIniBufInt(lpBuf, STR_PLC, STR_TIMEOUT, 100, 30000, -1);
	if (lpVat->nTimeOut == -1) {
		pWriteVatMsg(lpFileName, lpBuf, STR_PLC, STR_TIMEOUT);
		return FALSE;
	}
	lpVat->nRack = GetIniBufInt(lpBuf, STR_PLC, STR_RACK, 0, 31, -1);
	if (lpVat->nRack == -1) {
		pWriteVatMsg(lpFileName, lpBuf, STR_PLC, STR_RACK);
		return FALSE;
	}
	lpVat->nSlot = GetIniBufInt(lpBuf, STR_PLC, STR_SLOT, 0, 18, -1);
	if (lpVat->nSlot == -1) {
		pWriteVatMsg(lpFileName, lpBuf, STR_PLC, STR_SLOT);
		return FALSE;
	}
	lpVat->nVarCnt = GetIniBufInt(lpBuf, STR_PLC, STR_VARCOUNT, 1, MAX_S7VARS, -1);
	if (lpVat->nVarCnt == -1) {
		pWriteVatMsg(lpFileName, lpBuf, STR_PLC, STR_VARCOUNT);
		return FALSE;
	}
	for (i = 0; i < lpVat->nVarCnt; i++) {
		StrPrint(cSect, "%s%d", STR_VAR, i);
		nLen = GetIniBufStr(lpBuf, cSect, STR_VAR, cBuf, sizeof(cBuf), NULL);
		if (pGetVarInfo(cBuf, &lpVat->VarInfo[i])) {
			FillViewModeList(FALSE, FALSE, 0, &lpVat->VarInfo[i], &nViewModeCnt, nViewModeList);
			pName = lpVat->VarInfo[i].pName;
			for (j = 0; j < lpVat->VarInfo[i].nCount; j++) {
				StrPrint(cPar, "%s%d", STR_NAME, j);
				nLen = GetIniBufStr(lpBuf, cSect, cPar, pName, S7MAX_NAMESIZE, NULL);
				StrPrint(cPar, "%s%d", STR_VIEW, j);
				nLen = GetIniBufStr(lpBuf, cSect, cPar, cBuf, sizeof(cBuf), NULL);
				if (nLen) {
					for (k = 0; k < nViewModeCnt; k++) {
						LoadString(g_hResource, nViewModeList[k], cView, sizeof(cView));
						if (StrICmp(cBuf, cView) == 0) {
							lpVat->VarInfo[i].pView[j] = nViewModeList[k] - IDM_VM_FIRST;
							break;
						}
					}
				}
				pName += S7MAX_NAMESIZE;
			}
		}
		else {
			pWriteVatMsg(lpFileName, lpBuf, cSect, STR_VAR);
			return FALSE;
		}
	}
	return TRUE;
}
// **********************************************************************************
BOOL __stdcall Read_VAT(LPSTR lpFileName, LPVATDATA lpVat) {
char		cFile[MAX_PATH];
LPSTR		pBuf;
LPVATDATA	pWork;
BOOL		bRet, bNewIF, bNewCon;
INT32		nDlg;

	FSplit(FALSE, NULL, cFile, lpFileName);
	pBuf = LoadTextFile(lpFileName, LTF_ADDCRLF | LTF_EXTRABUF, MAX_VATFILESIZE, NULL);
	if (pBuf) {
		pWork = GetMem(GMM_CLEAR, sizeof(VATDATA));
		bRet = pRead_VAT(lpFileName, pBuf, pWork);
		FreeMem(pBuf);
		bNewIF = lpVat->hIF && (lpVat->nIFMode != pWork->nIFMode);
		bNewCon = lpVat->hCon && (bNewIF || (lpVat->nAddr != pWork->nAddr));
		if (bRet && bNewCon) {
			m_pInfo = GetMem(GMM_CLEAR, sizeof(MODEINFO));
			m_pInfo->nOldMode = lpVat->nIFMode;
			m_pInfo->nNewMode = pWork->nIFMode;
			m_pInfo->nOldAddr = lpVat->nAddr;
			m_pInfo->nNewAddr = pWork->nAddr;
			StrCpy(m_pInfo->cOldName, lpVat->cPlcName);
			StrCpy(m_pInfo->cNewName, pWork->cPlcName);
			nDlg = DialogBox(g_hInstance, RESSTR(IDD_LOAD_MODE), g_hWndMain, pModeSelect);
			bRet = nDlg == IDOK;
			if (bRet && (m_nLastMode == 0)) {
				bNewIF = bNewCon = FALSE;
			}
			FreeMem(m_pInfo);
			m_pInfo = NULL;
		}
		if (bRet) {
			VAT_Done(lpVat, bNewIF, bNewCon, TRUE, FALSE);
			if (!lpVat->hIF) {
				lpVat->nIFMode = pWork->nIFMode;
				lpVat->hIF = S7_Interface_Init(lpVat->nIFMode);
				WriteMsg(IDS_IF_INIT, 0, NULL);
			}
			if (lpVat->hIF && !lpVat->hCon) {
				StrCpy(lpVat->cPlcName, pWork->cPlcName);
				lpVat->nAddr = pWork->nAddr;
				lpVat->nRack = pWork->nRack;
				lpVat->nSlot = pWork->nSlot;
				lpVat->nTimeOut = pWork->nTimeOut;
				lpVat->hCon = S7_Connection_Init(lpVat->hIF, lpVat->cPlcName, lpVat->nTimeOut, lpVat->nAddr, lpVat->nRack, lpVat->nSlot, DEF_S7PDUSIZE);
				WriteMsg(IDS_CON_INIT, 0, NULL);
			}
			lpVat->nVarCnt = pWork->nVarCnt;
			MemCpy(lpVat->VarInfo, pWork->VarInfo, sizeof(lpVat->VarInfo));
			if (lpVat->hIF && lpVat->hCon) DoView(TRUE, TRUE);
		}
	}
	else {
		pWriteIOMsg(cFile, LFD_TITLE, "can't load");
		bRet = FALSE;
	}
	return bRet;
}
// **********************************************************************************
BOOL __stdcall Load_VAT(LPSTR lpFileName, LPVATDATA lpVat) {
char		cFile[MAX_PATH], cFolder[MAX_PATH];
BOOL		bRet;

	pCheckFileName(lpFileName);
	FSplit(FALSE, cFolder, NULL, lpFileName);
	StrCpy(cFile, lpFileName);
	bRet = OpenFileDlg(g_hWndMain, LFD_TITLE, cFile, cFolder, LSFD_FILTER, STR_EXT_VAT, LFD_OPENFLAGS, LVCMD_DETAILS, NULL);
	if (bRet) {
		bRet = Read_VAT(cFile, lpVat);
		if (bRet) StrCpy(lpFileName, cFile);
	}
	return bRet;
}
