/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * s7comtest - s7comtest.c											*
 ********************************************************************/
#define RESTART_MAIN
// #define WIN32_LEAN_AND_MEAN
#include "s7comtest.h"
#pragma comment(lib, "skclib32")
#ifdef USE_DLL
#pragma comment(lib, "s7comx32")
#else
#pragma comment(lib, "s7com32")
#endif

// Globlis vltozk
HWND				g_hWndStatus					= NULL;
INT32				g_nStatusHeight					= 0;
LPEDITWIN			g_pMainEdit						= NULL;
INT32				g_nFont							= NORMAL_FONT;
HFONT				g_hFont							= NULL;
BOOL				g_bLoaded						= FALSE;
HFONT				g_hListFont						= NULL;
INT32				g_nFontSize[MAX_FONT]			= {SMALL_FONTSIZE, NORMAL_FONTSIZE, LARGE_FONTSIZE};
HBRUSH				g_hRedBrush						= NULL;
VARINFO				g_ActVar						= {0};
VATDATA				g_VAT							= {0};
LPSTR				g_VarTypes[S7VT_MAX]			= {"Bit", "Byte", "Short", "Char", "Word", "Int", "DWord", "DInt", "Time", "TOD", "S5Time", "Real", "Date&Time", "Date", "Timer", "Counter"};
#ifdef LANGUAGE_ENGLISH
LPSTR				g_AreaTypes[S7AT_MAX]			= {"Input", "Output", "Flag", "DB", "Timer", "Counter"};
#endif
#ifdef LANGUAGE_HUNGARIAN
LPSTR				g_AreaTypes[S7AT_MAX]			= {"Bemenet", "Kimenet", "Merker", "DB", "S5 id", "Szmll"};
#endif
char				g_cAreaName[S7AT_MAX]			= {'E', 'A', 'M', 'D', 'T', 'Z'};
char				g_cSizeName[MAX_SIZENAME]		= {'X', 'B', 'W', 'D', 'Q'};
char				g_cVatName[MAX_PATH]			= {0};
LPSTR				g_pIFMode[IFM_MAX]				= {"TCP", "S7ONLINE", "CP_L2_1", "CP_L2_2"};
// Loklis vltozk
static BOOL			m_bMinimized					= FALSE;
// **********************************************************************************
static LRESULT CALLBACK MainWndProc(HWND hWnd, UINT32 uMsg, WPARAM wParam, LPARAM lParam);
static void __stdcall TimerProc(HWND hWnd, UINT32 uMsg, UINT32 idEvent, ULONG dwTime);
// **********************************************************************************
INT32 __stdcall PreMain(INT32 nRTErr) {

	return nRTErr;
}
// **********************************************************************************
static INT32 __cdecl CreateStatusBar() {
INT32	paParts[2];

// Sttusz sor
	g_hWndStatus = CreateWindow(STATUSCLASSNAME, NULL, WS_CHILD | WS_VISIBLE | SBARS_SIZEGRIP,
									0, 0, 0, 0, g_hWndMain, (HMENU) IDC_STATUSBAR, NULL, NULL);
	if (!g_hWndStatus) return IDS_ERR_STATUSBAR;
	paParts[0] = GetTimeStrWidth(g_hWndStatus, TRUE, 0, 2);
	paParts[1] = -1;
	SendMessage(g_hWndStatus, SB_SETPARTS, (WPARAM) 2, (LPARAM) paParts);
	return 0;
}
// **********************************************************************************
static void __cdecl ViewPlcInfo() {
char	cBuf[256], cAddr[32];

	if (g_VAT.hCon) {
		StrPrint(cAddr, g_VAT.nIFMode == IFM_TCP ? "%a" : "%d", g_VAT.nAddr);
		StrPrint(cBuf, " %s : %s, Rack : %d, Slot : %d%[ (%s)%]", g_pIFMode[g_VAT.nIFMode], cAddr, g_VAT.nRack, g_VAT.nSlot, g_VAT.cPlcName, g_VAT.cPlcName[0]);
	}
	else if (g_VAT.hIF) {
		StrCpy(cBuf, g_pIFMode[g_VAT.nIFMode]);
	}
	else {
		cBuf[0] = 0;
	}
	SendMessage(GetDlgItem(g_hWndMain, IDC_STATUSBAR), SB_SETTEXT, 1, (LPARAM) cBuf);
}
// **********************************************************************************
static INT32 __stdcall Application_Init(LPSTR lpCmdLine, INT32 nCmdShow) {
HWND		hWnd;
LPSTR		pNext;
INT32		x, y, iWidth, iHeight, nRet, nParLen;
RECT		rWork, rView;
char		cClass[64], cTitle[MAX_PATH], cFile[MAX_PATH];
BOOL		bPrev, bExists;

	CommCtrl_Init(ICC_ANY_CLASSES);
	pNext = GetParamStr(g_cVatName, lpCmdLine, MAX_PATH, &nParLen);
	bExists = nParLen && PathExists(g_cVatName);
	bPrev = PrevInstanceExists(!bExists, TRUE, IDS_APPCLASS, sizeof(cClass), cClass, IDS_APPTITLE, sizeof(cTitle), cTitle);
	if (bPrev && !bExists) return IDS_ERR_NONE;
	if (bExists) {
		FSplit(FALSE, NULL, cFile, g_cVatName);
		MultiCatN(sizeof(cTitle), cTitle, NULL, " - ", cFile, NULL);
	}
	if (!RegisterWndClass(MainWndProc, cClass, IDI_MAINICON, IDM_MAINMENU, COLOR_WINDOW, 0)) return IDS_ERR_CLASS;
	GetWorkArea(&rWork, TRUE);
	iWidth = 3 * (rWork.right >> 2);
	iHeight = 3 * (rWork.bottom >> 2);
	x = rWork.left + (rWork.right >> 3);
	y = rWork.top + (rWork.bottom >> 3);
	g_hWndMain = CreateWindow(cClass, cTitle, WS_OVERLAPPEDWINDOW, x, y, iWidth, iHeight, NULL, NULL, g_hInstance, NULL);
	if (!g_hWndMain) return IDS_ERR_MAINWIN;
// Sttusz sor
	if (nRet = CreateStatusBar()) return nRet;
	GetViewRect(g_hWndMain, NULL, &g_nStatusHeight, &rView);
	hWnd = CreateWindowEx(WS_EX_STATICEDGE, WC_EDIT, NULL, WS_VISIBLE | WS_CHILDWINDOW | WS_CLIPSIBLINGS | ES_MULTILINE |
							WS_VSCROLL | ES_AUTOVSCROLL |  ES_NOHIDESEL | WS_HSCROLL |  ES_AUTOHSCROLL | ES_LEFT | ES_READONLY,
							rView.left, rView.top, rView.right, rView.bottom, g_hWndMain, (HMENU) IDC_LIST, NULL, NULL);
	if (!hWnd) return IDS_ERR_CHILDWIN;
	g_pMainEdit = EditWin_Init(g_hWndMain, hWnd, 64000, 400);
	SetPriorityClass(_getptd()->hThread, REALTIME_PRIORITY_CLASS);
	g_nAppState |= APST_WINREADY;
	SetListFont(NORMAL_FONT);
	g_hListFont = CreateLogFont(g_hWndMain, -10, FW_NORMAL, DEFAULT_CHARSET, STR_COURIERNEW);
	ShowWindow(g_hWndMain, nCmdShow);
	UpdateWindow(g_hWndMain);
	SetTimer(g_hWndMain, IDC_TIMER, 100, TimerProc);
	g_hRedBrush = CreateSolidBrush(RGB_LIGHTRED);
	VAT_Init(&g_VAT);
	if (bExists) {
		Read_VAT(g_cVatName, &g_VAT);
		EnableMenus(g_VAT.hIF ? MENU_SETON : MENU_SETOFF, g_VAT.hCon ? MENU_SETON : MENU_SETOFF, TRUE);
		ViewPlcInfo();
		g_bLoaded = TRUE;
	}
	return nRet;
}
// **********************************************************************************
static void __cdecl Application_Done() {

	if (g_VAT.hIF) S7_Interface_Done(g_VAT.hIF);
	DeleteObject(g_hFont);
	DeleteObject(g_hListFont);
	DeleteObject(g_hRedBrush);
	EditWin_Done(g_pMainEdit);
}
// **********************************************************************************
INT32 __stdcall WinMainX(LPSTR lpCmdLine, INT32 nCmdShow) {
LPTIDDATA	pTid;
BOOL		bErr;
INT32		nRet, nErr;

	__try {
		if (nRet = Application_Init(lpCmdLine, SW_SHOWNORMAL)) {
			if (nRet != IDS_ERR_NONE) MsgBox(g_hWndMain, RESSTR(IDS_MSGERRORTITLE), RESSTR(nRet), NULL, MB_OK | MB_ICONERROR);
			nRet -= IDS_ERR_NONE;
		}
		else {
			pTid = _getptd();
			pTid->hWnd = g_hWndMain;
			pTid->hAccel = LoadAccelerators(g_hInstance, RESSTR(IDA_MAINACCEL));
			nRet = MessageLoop(&bErr);
		}
	}
	__except(EXCEPTION_EXECUTE_HANDLER) {
		nErr = GetExceptionCode();
		MsgBox(g_hWndMain, RESSTR(IDS_EXCEPTIONTITLE), "I'm sorry. I made a mistake. :-(\r\nUnhandled exception", NULL, MB_OK | MB_ICONERROR);
	} // end of try - except
	KillProcess_Start(10000);
	Application_Done();
	KillProcess_Break();
	return nRet;
}
// **********************************************************************************
static LRESULT CALLBACK MainWndProc(HWND hWnd, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	lpDIS;
PAINTSTRUCT			ps;
BUSPARBLK			Bus;
SYSTEMTIME			st;
HDC					hDC;
char				cBuf[256];
INT32				wmId, wmEvent, iBkMode, nRet, nState, nErr, nCount;
LPSTR				cStatus;
BOOL				bChanged, bProcessed, bMinimize, bRet;
COLORREF			crColor;
RECT				rc, rView;

	bChanged = FALSE;
	bProcessed = TRUE;
	nRet = 0;
	switch (uMsg) {
	case WM_CREATE:
		break;
	case WM_ACTIVATE:
		if (wParam) SetFocus(g_pMainEdit->hEdit);
		break;
	case WM_CLOSE:
		wParam = IDM_EXIT;
	case WM_COMMAND:
		wmId    = LOWORD(wParam);
		wmEvent = HIWORD(wParam);
		switch (wmId) {
		case IDM_LOAD:
			bRet = Load_VAT(g_cVatName, &g_VAT);
			if (bRet) {
				EnableMenus(g_VAT.hIF ? MENU_SETON : MENU_SETOFF, g_VAT.hCon ? MENU_SETON : MENU_SETOFF, TRUE);
				ViewPlcInfo();
				g_bLoaded = TRUE;
				SetWinTitle(hWnd, IDS_APPTITLE);
			}
			break;
		case IDM_SAVE:
			bRet = Save_VAT(g_cVatName, &g_VAT);
			if (bRet) {
				g_bLoaded = TRUE;
				SetWinTitle(hWnd, IDS_APPTITLE);
			}
			break;
		case IDM_IF_OPEN:
			bRet = OpenInterface();
			if (bRet) {
				EnableMenus(MENU_SETON, MENU_UNCHANGED, FALSE);
				ViewPlcInfo();
			}
			break;
		case IDM_CON_OPEN:
			bRet = OpenConnection(FALSE);
			if (bRet) {
				EnableMenus(MENU_UNCHANGED, MENU_SETON, FALSE);
				ViewPlcInfo();
			}
			break;
		case IDM_CON_MODIFY:
			bRet = OpenConnection(TRUE);
			if (bRet) {
				EnableMenus(MENU_UNCHANGED, MENU_SETON, FALSE);
				ViewPlcInfo();
			}
			break;
		case IDM_CONNECT:
			nErr = S7_Connect(g_VAT.hCon);
			WriteMsg(IDS_CONNECT, 0, NULL);
			if (!nErr) EnableMenus(MENU_UNCHANGED, MENU_SETON, FALSE);
			break;
		case IDM_DISCONNECT:
			nErr = S7_Disconnect(g_VAT.hCon);
			WriteMsg(IDS_DISCONNECT, 0, NULL);
			if (!nErr) EnableMenus(MENU_UNCHANGED, MENU_SETON, FALSE);
			break;
		case IDM_IF_CLOSE:
		case IDM_CON_CLOSE:
			if (g_VAT.hCon) {
				g_VAT.hCon = S7_Connection_Done(g_VAT.hCon);
				WriteMsg(IDS_CON_DONE, 0, NULL);
				EnableMenus(MENU_UNCHANGED, MENU_SETOFF, FALSE);
			}
			if (wmId == IDM_IF_CLOSE) {
				g_VAT.hIF = S7_Interface_Done(g_VAT.hIF);
				WriteMsg(IDS_IF_DONE, 0, NULL);
				EnableMenus(MENU_SETOFF, MENU_UNCHANGED, FALSE);
			}
			ViewPlcInfo();
			break;
		case IDM_PARTNERS:
			nErr = S7_OnLine_Partners(g_VAT.hIF, 1000, sizeof(cBuf), cBuf, &nCount);
			WriteMsg(IDS_PARTNERS, nCount, cBuf);
			break;
		case IDM_BUSPARS:
			nErr = S7_OnLine_BusPars(g_VAT.hIF, 1000, &Bus);
			WriteMsg(IDS_BUSPARS, 0, &Bus);
			break;
		case IDM_CPU_STATE:
			nErr = S7_GetCpuState(g_VAT.hCon, &nState);
			WriteMsg(IDS_CPUSTATE, nState, NULL);
			break;
		case IDM_CPU_START:
			DoCpuStart();
			break;
		case IDM_CPU_STOP:
			nErr = S7_CpuStop(g_VAT.hCon);
			WriteMsg(IDS_CPUSTOP, 0, NULL);
			break;
		case IDM_GETCLOCK:
			nErr = S7_GetCpuClock(g_VAT.hCon, &st);
			WriteMsg(IDS_GETCLOCK, 0, &st);
			break;
		case IDM_SETCLOCK:
			DoSetClock();
			break;
		case IDM_LOGIN:
			DoSessionLogin();
			break;
		case IDM_LOGOUT:
			nErr = S7_SessionLogout(g_VAT.hCon);
			WriteMsg(IDS_LOGOUT, 0, NULL);
			break;
		case IDM_READ:
			DoRead();
			EnableMenus(MENU_UNCHANGED, MENU_UNCHANGED, TRUE);
			break;
		case IDM_WRITE:
			DoWrite();
			EnableMenus(MENU_UNCHANGED, MENU_UNCHANGED, TRUE);
			break;
		case IDM_ABOUT:
			AboutBox(g_hWndMain, IDD_ABOUTBOX);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case IDM_FONTSMALL:
		case IDM_FONTNORMAL:
		case IDM_FONTLARGE:
			SetListFont(wmId - IDM_FONTSMALL);
			break;
		default:
			bProcessed = FALSE;
		} // end switch (wmId)
		break;
	case WM_CTLCOLORSTATIC:
		hDC = (HDC) wParam;
		SetTextColor(hDC, GetSysColor(COLOR_WINDOWTEXT));
		crColor = GetSysColor(COLOR_WINDOW);
		SetBkColor(hDC, crColor);
		nRet = (INT32) CreateSolidBrush(crColor);
		break;
	case WM_DISPLAYCHANGE:
		break;
	case WM_DRAWITEM:
		if (wParam == IDC_STATUSBAR) {
			lpDIS=(LPDRAWITEMSTRUCT)lParam;
			cStatus =(LPSTR)lpDIS->itemData;
			iBkMode = SetBkMode(lpDIS->hDC, TRANSPARENT);
			lpDIS->rcItem.top++;
			MemClr(&rc, sizeof(RECT));
			DrawText(lpDIS->hDC, cStatus, -1, &rc, DT_CALCRECT);
			DrawText(lpDIS->hDC, cStatus, -1, &lpDIS->rcItem, DT_CENTER | DT_VCENTER);
			SetBkMode(lpDIS->hDC, iBkMode);
		}
		break;
	case WM_GETMINMAXINFO:
		if (g_nAppState & APST_WINREADY) {
			SetMinMaxInfo(hWnd, 0, 0, 0, 0, NULL, &g_nStatusHeight, (LPMINMAXINFO) lParam);
		}
		else bProcessed = FALSE;
		break;
	case WM_SIZE:
		SendMessage(g_hWndStatus, WM_SIZE, 0, 0);
		if (GetViewRect(g_hWndMain, NULL, &g_nStatusHeight, &rView)) {
			SetWindowPos(g_pMainEdit->hEdit, HWND_TOP, rView.left, rView.top, rView.right, rView.bottom, SWP_NOZORDER | SWP_SHOWWINDOW);
		}
		bMinimize = wParam == SIZE_MINIMIZED;
		if (xor(bMinimize, m_bMinimized)) {
			SendMessage(g_pMainEdit->hEdit, WM_SETREDRAW, !bMinimize, 0);
			if (!bMinimize) RedrawWindow(g_pMainEdit->hEdit, NULL, NULL, RDW_INVALIDATE);
		}
		m_bMinimized = bMinimize;
		break;
	case WM_PAINT:
		hDC = BeginPaint(hWnd, &ps);
		EndPaint(hWnd, &ps);
		break;
	case WM_SK_SHOW:
		ShowWindow(hWnd, wParam);
		break;
	case WM_SK_LOG:
		EditWin_Update((LPEDITWIN) lParam, (LPSTR) wParam, TRUE);
		break;
	case WM_SK_TIMEOUT:
		break;
	case WM_DESTROY:
		DeleteObjectEx(&g_hFont);			
		KillTimer(hWnd, IDC_TIMER);
		PostQuitMessage(0);
		break;
	default:
		bProcessed = FALSE;
	} // end switch (Message)
	if (!bProcessed) nRet = DefWindowProc(hWnd, uMsg, wParam, lParam);
	return nRet;
}
// **********************************************************************************
static void __stdcall TimerProc(HWND hWnd, UINT32 uMsg, UINT32 idEvent, ULONG dwTime) {
static INT32	nPrevSec	= -1;
BOOL			bChg;

	bChg = DisplayTime(g_hWndStatus, FALSE, &nPrevSec, NULL, NULL);
}
