;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - fpower10.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

.CODE

      _DCon1e0     DD        1, 10, 100, 1000, 10000, 100000, 1000000, 10000000
      _FCon1e8     DT        1.0e8, 1.0e16, 1.0e32, 1.0e64, 1.0e128, 1.0e256, 1.0e512, 1.0e1024, 1.0e2048
      _FCon1e4096  DT        1.0e4096

OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE
;*********************************************************************
;Be:eax = exponent
;   ST(0)
;Ki:ST(0):=ST(0)*10^eax
;	eax, ecx, edx destroyed
	asmFPower10		PROC
					cmp		eax, 4096
					jle		@@1
					fld		_FCon1e4096
					fmul
					sub		eax, 4096
		@@1:		cmp		eax, -4096
					jge		@@2
					fld		_FCon1e4096
					fdiv
					add		eax, 4096
		@@2:		mov		ecx, eax
					test	eax, eax
					jz		@@8
					jns		@@3
					neg		eax
		@@3:		mov		edx, eax
					and		edx, 7
					shl		edx, 2
					fild	[_DCon1e0 + edx]
					shr		eax, 3
					lea		edx, _FCon1e8
					jmp		@@6
		@@4:		shr		eax, 1
					jnc		@@5
					fld		tbyte ptr [edx]
					fmul
		@@5:		add		edx, 10
		@@6:		test	eax, eax
					jnz		@@4
					test	ecx, ecx
					js		@@7
					fmul
					jmp		@@8
		@@7:		fdiv
		@@8:		ret
	asmFPower10		ENDP

END
