;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - fltstr.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

extern c	_fltused : dword

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;INT32 __stdcall FltStr(LPSTR lpResult, double fVal, INT32 nMode, INT32 nDec, INT32 nLen)
	FltStr			PROC	USES ebx esi edi, lpResult: DWORD, fValue: QWORD, nMode: DWORD, nDec: DWORD, nLen: DWORD
	LOCAL nAlign		:WORD
	LOCAL fExtended		:TBYTE
	LOCAL cDigits[20]	:BYTE
					lea		edi, cDigits
					fld		fValue
					fstp	fExtended
					fwait
					movzx	eax, word ptr [fExtended + 8]
					mov		esi, nMode
					and		esi, NF_FLOATMASK
					test	ax, ax
					jns		@@01
					or		esi, NF_NEGATIVE
		@@01:		and		ax, 07FFFh
					jnz		@@02
					and		esi, not NF_PLUSSIGN
					mov		ecx, 4
					mov		eax,'0000'
					rep	stosd
					stosw
					xor		ebx, ebx
					jmp		@@10
		@@02:		cmp		ax, 07FFFh
					jne		@@07
					cmp		dword ptr [fExtended + 4], 080000000h
					jne		@@03
					cmp		dword ptr [fExtended], 0
					je		@@04
		@@03:		mov		ax, '??'
					stosb
					jmp		@@06
		@@04:		mov		al, '+'
					test	esi, NF_NEGATIVE
					jz		@@05
					mov		al, '-'
		@@05:		stosb
					mov		ax, 'oo'
		@@06:		stosw
					xor		eax, eax
					stosb
					mov		nDec, eax
					mov		esi, NF_HEX						; <> NF_DEC
					mov		ebx, 000000400h
					jmp		@@11
		@@07:		mov		word ptr [fExtended + 8], ax
					fld		fExtended
					sub		eax, 000003FFFh
					mov		edx, 1292913986
					imul	edx
					mov		ebx, edx							; ebx = exponens
					mov		eax, 17
					sub		eax, edx
					call	asmFPower10
					frndint
					fld		_FCon1e18
					fcomp
					fstsw	ax
					sahf
					ja		@@08
					fidiv	g_nTen
					inc		ebx
		@@08:		fbstp	fExtended
					fwait
					mov		ecx, 9
		@@09:		mov		al, byte ptr [fExtended + ecx - 1]
					mov		ah, al
					shr		al, 4
					and		ah, 00Fh
					add		ax, '00'
					stosw
					loop	@@09
		@@10:		mov		eax, ebx
					movzx	ebx, byte ptr nDec
					mov		bh, 19
		@@11:		mov		word ptr [edi],'0'
					movzx	ecx, byte ptr nLen
					mov		edx, esi
					lea		esi, cDigits
					mov		edi, lpResult
					call	asmIntFltStr
					ret
      _FCon1e18		dt		1.0e18
	FltStr			ENDP

END
