;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - fltval.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc


		m87IE			equ		00001h			; rvnytelen mvelet
		m87DE			equ		00002h			; denormlis
		m87ZE			equ		00004h			; nullval oszts
		m87OE			equ		00008h			; tlcsorduls
		m87UE			equ		00010h			; alulcsorduls
		m87PE			equ		00020h			; pontossg
		m87SF			equ		00040h			; stack
		m87ES			equ		00080h			; error sum
		m87C0			equ		00100h
		m87C1			equ		00200h
		m87C2			equ		00400h
		m87C3			equ		04000h

.LIST

extern c	_fltused : dword

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;double __stdcall FltVal(LPSTR lpString, INT32 nMode, LPINT32 lpScan);
	FltVal			PROC	USES ebx esi edi, @@lpString: DWORD, @@nMode: DWORD, @@lpScan: DWORD
	LOCAL @@LocInfo		:LOCALINFO
	LOCAL @@nGrpCnt		:BYTE
	LOCAL @@nGrpDigit	:BYTE
	LOCAL @@bDecPoint	:BYTE
	LOCAL @@bOK			:BYTE
	LOCAL @@bSign[4]	:BYTE
	LOCAL @@nTemp		:DWORD

					call	_getptd
					mov		eax, [eax].TIDDATA.LocInfo.nInfo
					mov		@@LocInfo.nInfo, eax
					fnclex
					fldz
					xor		eax, eax
					mov		dword ptr @@bOK, eax
					mov		edi, @@nMode
					mov		esi, @@lpString
					invoke	asmGetNumSign
					mov		@@bSign, dl
					xor		ebx, ebx						; exponens
		@@01:		test	edi, NF_SEP
					jz		@@04
					cmp		al, @@LocInfo.cSeparator
					jne		@@04
					mov		al, @@nGrpDigit
					cmp		al, 0
					je		@@11
					mov		dl, g_nNumSepTab
					cmp		@@nGrpCnt, 0
					jne		@@02
					cmp		al, dl
					jbe		@@03
					test	edi, NF_NOSEPERR
					jz		@@11
					mov		al, dl
		@@02:		cmp		al, dl
					je		@@03
					test	edi, NF_NOSEPERR
					jz		@@11
		@@03:		mov		@@nGrpDigit, 0
					inc		@@nGrpCnt
					lodsb
					jmp		@@01		
		@@04:		cmp		al, @@LocInfo.cDecPoint
					jne		@@05
					cmp		@@bDecPoint, 0
					jne		@@11
					mov		@@bDecPoint, 1
					mov		@@nGrpDigit, 0
					lodsb
					jmp		@@01
		@@05:		call	asmUCase
					cmp		al, 'E'
					je		@@07
					sub		al, '0'
					jc		@@12
					cmp		al, 9
					ja		@@12
					inc		@@nGrpDigit
					mov		@@bOK, 1
					cmp		@@bDecPoint, 0
					je		@@06
					dec		ebx
		@@06:		mov		@@nTemp, eax
					fimul	g_nTen
					fiadd	@@nTemp
					lodsb
					jmp		@@01
		@@07:		xor		edx, edx
					xor		ecx, ecx
					lodsb
					cmp		al, '+'
					je		@@08
					cmp		al, '-'
					jne		@@11
					inc		dh
		@@08:		lodsb
					sub		al, '0'
					jc		@@09
					cmp		al, 9
					ja		@@09
					inc		dl
					imul	ecx, ecx, 10
					add		ecx, eax
					cmp		ecx, 4999
					ja		@@11
					jmp		@@08
		@@09:		test	dl, dl
					jz		@@11
					test	dh, dh
					jz		@@10
					neg		ecx
		@@10:		add		ebx, ecx
					jmp		@@12	
		@@11:		mov		@@bOK, 0
		@@12:		cmp		@@bOK, 0
					je		@@14
					mov		eax, ebx
					call	asmFPower10
					cmp		@@bSign, 0
					je		@@13
					fchs
		@@13:		fnstsw	ax
					test	ax, m87IE + m87OE
					jz		@@15
		@@14:		fstp	st
					fldz
		@@15:		sub		esi, @@lpString
					dec		esi
					jz		@@16
					cmp		@@bOK, 0
					jne		@@16
					neg		esi
		@@16:		mov		ecx, @@lpScan
					test	ecx, ecx
					jz		@@17
					mov		[ecx], esi
		@@17:		ret
	FltVal			ENDP

END
