;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - intfltstr.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;Be:esi = Digit puffer
;   eax = exponent
;   ebx = decimals
;   cl  = len
;   edx = digitszm
;   edi = string
;Ki:ecx = string len
;   eax, ebx, ecx, edx, esi, edi romlik
	asmIntFltStr	PROC
	LOCAL @@LocInfo			:LOCALINFO
	LOCAL @@pDigits			:DWORD
	LOCAL @@pResult			:DWORD
	LOCAL @@nExponent		:DWORD
	LOCAL @@nMode			:DWORD
	LOCAL @@nTemp			:DWORD
	LOCAL @@nAlign			:BYTE
	LOCAL @@nLen			:BYTE
	LOCAL @@nDecimals		:BYTE
	LOCAL @@nDigits			:BYTE
	LOCAL @@cNumStr[128]	:BYTE

					mov		@@pDigits, esi
					mov		@@pResult, edi
					mov		@@nExponent, eax
					mov		@@nMode, edx
					mov		@@nLen, cl
					push	eax									; ecx, edx mr nem kell
					call	_getptd
					mov		eax, [eax].TIDDATA.LocInfo.nInfo
					mov		@@LocInfo.nInfo, eax
					pop		eax
					cmp		bl, 18
					jbe		@@01
					mov		bl, 18
		@@01:		mov		@@nDecimals, bl
					mov		@@nDigits, bh
					xor		edx, edx
					xchg	dl, bh
					inc		ebx
					test	@@nMode, NF_FLOATING
					jnz		@@02
					add		ebx, eax
		@@02:		cmp		ebx, edx
					jb		@@03
					mov		ebx, edx
					dec		ebx
		@@03:		cmp		byte ptr [esi + ebx], '5'
					mov		byte ptr [esi + ebx], 0
					jb		@@06
		@@04:		dec		ebx
					js		@@05
					inc		byte ptr [esi + ebx]
					cmp		byte ptr [esi + ebx], '9'
					jbe		@@06
					mov		byte ptr [esi + ebx], 0
					jmp		@@04
		@@05:		mov		word ptr [esi], '1'
					inc		eax
		@@06:		mov		@@nExponent, eax
					mov		edx, eax					; edx = exponens
					lea		edi, @@cNumStr
					mov		ebx, @@nMode
					test	ebx, NF_NEGATIVE			; eljel
					jnz		@@07
					test	ebx, NF_PLUSSIGN + NF_SPCSIGN
					jz		@@09
					mov		al,  '+'
					test	ebx, NF_PLUSSIGN
					jnz		@@08
					mov		al,  ' '
					jmp		@@08
		@@07:		mov		al, '-'
		@@08:		stosb
		@@09:		mov		ecx, ebx
					and		ecx, NF_BASEMASK
					mov		ch, [g_nNumSepTab + ecx]
					mov		cl, @@LocInfo.cSeparator
					test	ebx, NF_FLOATING
					jnz		@@17
					test	edx, edx					; exponens
					jns		@@10
					mov		al, '0'
					stosb
					jmp		@@12
		@@10:		mov		eax, edx
					div		ch
					inc		ah
		@@11:		call	asmGetDigit
					dec		edx
					js		@@12
					call	asmSepTest
					jmp		@@11
		@@12:		mov		@@nTemp, edx
					movzx	edx, @@nDecimals				; edx = tizedesek
					test	edx, edx
					jz		@@25
					mov		al, @@LocInfo.cDecPoint
					stosb
					mov		ah, ch
		@@13:		inc		@@nTemp
					jz		@@14
					mov		al, '0'
					stosb
					call	asmSepTest
					dec		edx
					jnz		@@13
		@@14:		dec		edx
					js		@@15
					call	asmGetDigit
					call	asmSepTest
					jmp		@@14
		@@15:		cmp		byte ptr [edi - 1], ' '
					jne		@@16
					dec		edi
		@@16:		mov		ah, @@LocInfo.cDecPoint
					call	asmTestDec
					jmp		@@25
		@@17:		call	asmGetDigit
					movzx	edx, @@nDecimals
					test	edx, edx
					jz		@@20
					mov		al, @@LocInfo.cDecPoint
					stosb
					mov		ah, ch
		@@18:		call	asmGetDigit
					dec		edx
					jz		@@19
					call	asmSepTest
					jmp		@@18
		@@19:		mov		ah, @@LocInfo.cDecPoint
					call	asmTestDec
		@@20:		mov		edx, @@nExponent
					mov		al, 'e'
					test	ebx, NF_UCASE
					jz		@@21
					mov		al, 'E'
		@@21:		stosb
					mov		al, '+'
					test	edx, edx
					jns		@@22
					mov		al, '-'
					neg		edx
		@@22:		stosb
					mov		eax, (100 * 256) + 10
					xchg	eax, edx
					cmp		eax, 99
					jbe		@@24
					div		dh
					mov		dh, ah
					cbw
					div		dl
					add		ax, '00'
					cmp		al, '0'
					jne		@@23
					stosb
		@@23:		shr		ax, 8
					stosb
					mov		al, dh
					cbw
		@@24:		div		dl
					add		ax, '00'
					stosw
		@@25:		mov		edx, edi
					lea		esi, @@cNumStr
					sub		edx, esi
					mov		edi, @@pResult
					xor		ebx, ebx
					movzx	ecx, @@nLen
					test	ecx, ecx
					jz		@@26
					cmp		edx, ecx
					ja		@@26
					mov		al, ' '
					sub		ecx, edx
					mov		ebx, ecx
					rep stosb
		@@26:		mov		ecx, edx
					add		ebx, ecx
					rep movsb
					xor		al, al
					stosb
					mov		eax, ebx
					ret
	asmIntFltStr	ENDP

OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

;*********************************************************************
;Be: edi
;    ah: LocInfo.cDecPoint
;Ki: al = trlt karakterek szma
	asmTestDec		PROC	PRIVATE
					xor		al, al
					test	ebx, NF_CLRZDEC
					jz		@@5
		@@1:		cmp		byte ptr [edi - 1], ah
					je		@@3
					cmp		byte ptr [edi - 1], '0'
					je		@@2
					cmp		byte ptr [edi - 1], cl
					jne		@@5
		@@2:		dec		edi
					inc		al
					jmp		@@1
		@@3:		test	ebx, NF_ONEZDEC
					jz		@@4
					inc		edi
					dec		al
					jmp		@@5
		@@4:		dec		edi
					inc		al
		@@5:		ret
	asmTestDec		ENDP
;*********************************************************************
;Be: esi = szmjegy puffer akt eleme
;    edi = sztring aktulis eleme
	asmGetDigit		PROC	PRIVATE
					lodsb
					test	al, al
					jnz		@@1
					mov		al, '0'
					dec		esi
		@@1:		stosb
					ret
	asmGetDigit		ENDP
;*********************************************************************
;Be:edi = sztring aktulis eleme
;   ah  = tagols szmll
;   cl  = tagols md
;   ch  = space szmll
	asmSepTest		PROC	PRIVATE
					dec		ah
					jnz		@@1
					mov		ah, ch
					test	ebx, NF_SEP
					jz		@@1
					mov		al, cl
					stosb
		@@1:		ret
	asmSepTest		ENDP

END
