;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - intstr.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

ABSMAXDIGIT			equ		68					; 64 bit + 4

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;INT32 __stdcall IntStr(LPSTR lpResult, INT64 nVal, INT32 nMode, INT32 nDec, INT32 nLen);
;***************************************************************
	IntStr			PROC	USES ebx esi edi, lpResult: DWORD, nValue: QWORD, nMode: DWORD, nDec: DWORD, nLen: DWORD
	LOCAL cDigits[ABSMAXDIGIT]	:BYTE
					mov		eax, dword ptr [nValue]
					mov		esi, dword ptr [nValue + 4]
					mov		ecx, nMode
					and		ecx, NF_INTMASK
					mov		ebx, ecx
					and		ebx, NF_BASEMASK
					test	ecx, NF_UNSIGNED
					jnz		@@01
					cmp		bl, NF_DEC
					jne		@@01
					test	esi, esi
					jns		@@01
					not		esi
					neg		eax
					sbb		esi, -1
					or		ecx, NF_NEGATIVE
		@@01:		mov		edx, eax
					or		edx, esi
					jnz		@@02
					and		ecx, not NF_PLUSSIGN
		@@02:		mov		nMode, ecx
					mov		dx, 00700h
					test	ecx, NF_UCASE
					jnz		@@03
					add		dh, 'a' - 'A'
		@@03:		movzx	ecx, dx
					mov		bl, [g_nBaseNum + ebx]
					lea		edi, cDigits + ABSMAXDIGIT - 2
					mov		word ptr [edi], '0'
		@@04:		xor		edx, edx
					xchg	eax, esi
					div		ebx
					xchg	eax, esi
					div		ebx
					cmp		dl, 9
					jbe		@@05
					add		dl, ch
		@@05:		add		dl, '0'
					dec		edi
					inc		cl
					mov		[edi], dl
					mov		edx, eax
					or		edx, esi
					jnz		@@04
					mov		edx, nMode
					movzx	ebx, byte ptr nDec
					test	edx, NF_SINGLE
					jnz		@@09
					test	edx, NF_ZFILL
					jz		@@08
					cmp		ebx, ABSMAXDIGIT - 4
					jbe		@@06
					mov		ebx, ABSMAXDIGIT - 4
		@@06:		sub		bl, cl
					jbe		@@08
		@@07:		dec		edi
					mov		byte ptr [edi], '0'
					inc		cl
					dec		bl
					jnz		@@07
		@@08:		xor		ebx, ebx
		@@09:		xor		ch, ch
					mov		eax, ecx
					dec		eax
					sub		eax, ebx
					mov		bh, cl
					inc		bh
					movzx	ecx, byte ptr nLen
					mov		esi, edi
					mov		edi, lpResult
					call	asmIntFltStr
					ret
	IntStr			ENDP

END
