include skglobals.inc
; Basic IP/UDP/SKDP structures

	MACADDRESS					UNION
								STRUC
		b0						DB				?
		b1						DB				?
		b2						DB				?
		b3						DB				?
		b4						DB				?
		b5						DB				?
								ENDS
								STRUC
		w0						DW				?
		w2						DW				?
		w4						DW				?
								ENDS
		d0						DD				?
    MACADDRESS					ENDS

	IPADDRESS					UNION
								STRUC
		b0						DB				?
		b1						DB				?
		b2						DB				?
		b3						DB				?
								ENDS
								STRUC
		w0						DW				?
		w2						DW				?
								ENDS
		d0						DD				?
	IPADDRESS					ENDS

	ETHHEADER					STRUC
		Dst						MACADDRESS		<>
		Src						MACADDRESS		<>
		Typ						DW				?
	ETHHEADER					ENDS

	ETH_MAXPACKETSIZE			EQU				(1518 - 4)
	ETH_MAXDATASIZE				EQU				(ETH_MAXPACKETSIZE - SIZE ETHHEADER)

	ETHPACKET					STRUC
		EthHead					ETHHEADER		<>
		EthData					DB				ETH_MAXDATASIZE DUP(?)
	ETHPACKET					ENDS

	IPHEADER					STRUC
		VL						DB				?              ; 045h 4 = Version
		TOS						DB				?
		Len						DW				?
		ID						DW				?
		FF						DW				?
		TTL						DB				?
		Protocol				DB				?
		ChkSum					DW				?
		SrcIP					IPADDRESS		<>
		DstIP					IPADDRESS		<>
	IPHEADER					ENDS

	IP_MAXDATASIZE				EQU				(ETH_MAXDATASIZE - SIZE IPHEADER)

	IPPACKET					STRUC
		IpHead					IPHEADER		<>
		IpData					DB				IP_MAXDATASIZE DUP(?)
	IPPACKET					ENDS

	ICMP_ECHOREQUEST			EQU				8
	ICMP_ECHOREPLY				EQU				0
	IPPROT_UDP					EQU				17

	ICMPHEADER					STRUC
		Typ						DB				?
		Cod 					DB				?
		ChkSum					DW				?
		ID						DW				?
		Seq						DW				?
	ICMPHEADER					ENDS

	ICMP_MAXDATASIZE			EQU				(IP_MAXDATASIZE - SIZE ICMPHEADER)

	ICMPPACKET					STRUC
		IpHead					IPHEADER		<>
		IcmpHead				ICMPHEADER		<>
		IcmpData				DB				ICMP_MAXDATASIZE DUP(?)
	ICMPPACKET					ENDS

	UDPHEADER					STRUC
		SrcPort					DW				?
		DstPort					DW				?
		Len						DW				?
		ChkSum					DW				?
	UDPHEADER					ENDS

	UDP_MAXDATASIZE				EQU				(IP_MAXDATASIZE - SIZE UDPHEADER)

	UDPPACKET					STRUC
		IpHead					IPHEADER		<>
		UdpHead					UDPHEADER		<>
		UdpData					DB				UDP_MAXDATASIZE DUP(?)
	UDPPACKET					ENDS

	SKDPHEADER					STRUC
		nID						DW				?
		nClntIdx				DB				?
		nSrvrIdx				DB				?
		nJobID					DB				?
		nFlags					DB				?
		nReqID					DW				?
		nFunction				DW				?
		nBlkOfs					DW				?
		nBlkCnt					DB				?
		nBlkID					DB				?
		nError					DB				?
		nChk					DB				?
	SKDPHEADER					ENDS

	SKDP_MAXDATASIZE			EQU				(UDP_MAXDATASIZE - SIZE SKDPHEADER)

	SKDP_MAXPACKETCOUNT			equ				64
	SKDP_MAXTRANSFERSIZE		equ				(SKDP_MAXPACKETCOUNT * SKDP_MAXDATASIZE)
	SKDP_MAXJOBDATASIZE			equ				(SKDP_MAXTRANSFERSIZE + SKDP_MAXDATASIZE)

	SKDP_MSGID					equ				'KS'
	SKDP_MAXJOB					equ				32
	SKDP_MAXFILES				equ				4
	SKDP_MAXFOLDER				equ				4						; 1 dword size
	SKDP_MINSTRSIZE				equ				2
	SKDP_MAXSTRSIZE				equ				256
	SKDP_MAXNAMESIZE			equ				24
	SKDP_MAXPATH				equ				128
; Error codes
	SKDPERR_NONE				equ				0
	SKDPERR_BADHANDLE			equ				1
	SKDPERR_NOCLASS				equ				2
	SKDPERR_NOTYPE				equ				3
	SKDPERR_NONUMBER			equ				4
	SKDPERR_BADTYPE				equ				5
	SKDPERR_NOMULTICAST			equ				6
	SKDPERR_CANTTERMINATE		equ				7
	SKDPERR_BADMODE				equ				8
	SKDPERR_NOSPACE				equ				9
	SKDPERR_TYPEINUSE			equ				10
	SKDPERR_BADCOMMAND			equ				11
	SKDPERR_CANTSEND			equ				12
	SKDPERR_CANTSET				equ				13
	SKDPERR_BADADDRESS			equ				14
	SKDPERR_CANTRESET			equ				15
	SKDPERR_NOPKTDRV			equ				16
	SKDPERR_NOPKTINT			equ				17
	SKDPERR_NOMACADDR			equ				18
	SKDPERR_BADMACSIZE			equ				19
	SKDPERR_INVALIDIP			equ				20
	SKDPERR_INVALIDMASK			equ				21
	SKDPERR_INVALIDGATEWAY		equ				22
	SKDPERR_BADPACKET			equ				23
	SKDPERR_BADPACKETSIZE		equ				24
	SKDPERR_ARPFULL				equ				25
	SKDPERR_TOOMANYREQUEST		equ				26
	SKDPERR_ARPTIMEOUT			equ				27
	SKDPERR_DUPLICATEDIP		equ				28
	SKDPERR_UNKNOWNMAC			equ				29
	SKDPERR_DNSTIMEOUT			equ				30
	SKDPERR_DNSFORMATERROR		equ				31
	SKDPERR_DNSSERVERFAILURE	equ				32
	SKDPERR_DNSNAMEERROR		equ				33
	SKDPERR_DNSUNIMPLEMENTED	equ				34
	SKDPERR_DNSREFUSED			equ				35
	SKDPERR_DNSINVALIDDATA		equ				46
	SKDPERR_DNSSTRTOOLONG		equ				47
	SKDPERR_DNSSTREMPTY			equ				48
	SKDPERR_DNSINVALIDANSWER	equ				49
	SKDPERR_MEMORY				equ				50
	SKDPERR_WINSOCK_INIT		equ				51
	SKDPERR_PCNAME				equ				52
	SKDPERR_SOCKET_CREATION		equ				53
	SKDPERR_IP_VERSION			equ				54
	SKDPERR_INTERFACE_LIST		equ				55
	SKDPERR_NET_DETECTION		equ				56
	SKDPERR_SOCKET_BIND			equ				57
	SKDPERR_SOCKET_OPTION		equ				58
	SKDPERR_CREATEEVENT			equ				59
	SKDPERR_EVENTSELECT			equ				60
	SKDPERR_THREADSTART			equ				61
	SKDPERR_THREADENDED			equ				62
	SKDPERR_BADCHKSUM			equ				63
	SKDPERR_JOBREINITIALIZED	equ				64
	SKDPERR_JOBINUSE			equ				65
	SKDPERR_JOBRELEASED			equ				66
	SKDPERR_JOBTABLEFULL		equ				67
	SKDPERR_INVALIDJOB			equ				68
	SKDPERR_BADJOBTYPE			equ				69
	SKDPERR_BADJOBIDX			equ				70
	SKDPERR_BADBLKCNT			equ				71
	SKDPERR_BADSRVRIDX			equ				72
	SKDPERR_SRVRIDXMISMATCH		equ				73
	SKDPERR_JOBIDMISMATCH		equ				74
	SKDPERR_JOBTYPEMISMATCH		equ				75
	SKDPERR_REQIDMISMATCH		equ				76
	SKDPERR_IPMISMATCH			equ				77
	SKDPERR_PORTMISMATCH		equ				78
	SKDPERR_INVALIDFLAGS		equ				79
	SKDPERR_BADBLKID			equ				80
	SKDPERR_BADBLKOFS			equ				81
	SKDPERR_BADBLKLEN			equ				82
	SKDPERR_BLKCNTMISMATCH		equ				83
	SKDPERR_FUNCTIONMISMATCH	equ				84
	SKDPERR_BADRCVLEN			equ				85
	SKDPERR_BADDATALEN			equ				86
	SKDPERR_BADSTRLEN			equ				87
	SKDPERR_SERVERDOWN			equ				88
	SKDPERR_SENDFAILED			equ				89
	SKDPERR_UNSUPPORTED			equ				90
	SKDPERR_TIMEOUT				equ				91
	SKDPERR_INVALIDSERVER		equ				92
	SKDPERR_INVALIDFOLDER		equ				93
	SKDPERR_INVALIDREQUEST		equ				94
	SKDPERR_FNDISABLED			equ				95
	SKDPERR_FNIMPOSSIBLE		equ				96
	SKDPERR_FOLDERNOTFOUND		equ				97
	SKDPERR_FILENOTFOUND		equ				98
	SKDPERR_BADFOLDERNAME		equ				99
	SKDPERR_BADFILENAME			equ				100
	SKDPERR_TOOMUCHFILE			equ				101
	SKDPERR_CANTOPEN			equ				102
	SKDPERR_CANTCREATE			equ				103
	SKDPERR_CANTDELETE			equ				104
	SKDPERR_CANTRENAME			equ				105
	SKDPERR_RIGHTS				equ				106
	SKDPERR_INVALIDHANDLE		equ				107
	SKDPERR_INVALIDDATA			equ				108
	SKDPERR_SEEK				equ				109
	SKDPERR_READ				equ				110
	SKDPERR_WRITE				equ				111
	SKDPERR_TOOBIG				equ				112
	SKDPERR_ACCESS				equ				113
	SKDPERR_DISCONNECTED		equ				114
	SKDPERR_THREADKILLED		equ				115
	SKDPERR_LAST				equ				115

	SKDPERRFL_REJECT			equ				000010000h

; SKDPPACKET Flags
	SKDPFL_REQUEST				equ				000h						; Don't use for mask!
	SKDPFL_REPLY				equ				001h
	SKDPFL_RETRY				equ				002h
	SKDPFL_RESEND				equ				004h
	SKDPFL_BROADCAST			equ				080h
	SKDPFL_TYPEMASK				equ				SKDPFL_REPLY
	SKDPFL_WAITING				equ				00100h
	SKDPFL_MULTIBLK				equ				00200h
	SKDPFL_SENT					equ				00400h

	SKDPFC_SRVRINIT				equ				0
	SKDPFC_SRVRDONE				equ				1
	SKDPFC_SRVRFIND				equ				2
	SKDPFC_MESSAGE				equ				3
	SKDPFC_ENDREQUEST			equ				4
	SKDPFC_VERSION				equ				5
	SKDPFC_GETTIME				equ				6
	SKDPFC_GETRIGHTS			equ				7
	SKDPFC_RESTART				equ				8
	SKDPFC_REBOOT				equ				9
	SKDPFC_QUIT					equ				10
	SKDPFC_UPDATE				equ				11
	SKDPFC_EXEC					equ				12
	SKDPFC_FINDFILE				equ				13
	SKDPFC_DIRCREATE			equ				14
	SKDPFC_DIRREMOVE			equ				15
	SKDPFC_FILEINFO				equ				16
	SKDPFC_SETFATTR				equ				17
	SKDPFC_SETFDATE				equ				18
	SKDPFC_FILERENAME			equ				19
	SKDPFC_FILEDELETE			equ				20
	SKDPFC_FILEIO				equ				21
	SKDPFC_SFVREAD				equ				22
	SKDPFC_CREATEDATA			equ				23
	SKDPFC_READKEY				equ				24
	SKDPFC_WRITEKEY				equ				25
	SKDPFC_USER					equ				512

	CHRSET_AUTO					equ				00100h
	CHRSET_NONE					equ				0
	CHRSET_WIN					equ				1
	CHRSET_CWI					equ				2
	CHRSET_852					equ				3
	CHRSET_LAST					equ				3

; Debug mask and code
	SKDP_DBGM_JOB				equ				001h
	SKDP_DBGM_RCV				equ				002h
	SKDP_DBGM_SND				equ				004h
	SKDP_DBGM_TOUT				equ				008h

	SKDP_CB_NONE				equ				0
	SKDP_CB_DBGGETJOB			equ				1
	SKDP_CB_DBGREPLYJOB			equ				2
	SKDP_CB_DBGRESETJOB			equ				3
	SKDP_CB_DBGFREEJOB			equ				4
	SKDP_CB_DBGSEND				equ				5
	SKDP_CB_DBGRECEIVE			equ				6
	SKDP_CB_DBGTIMEOUT			equ				7
	SKDP_CB_DBGLAST				equ				7
	SKDP_CB_FINDSRVR			equ				8
	SKDP_CB_MESSAGE				equ				9
	SKDP_CB_JOB					equ				10
	SKDP_CB_START				equ				11
	SKDP_CB_STOP				equ				12
	SKDP_CB_LIVE				equ				13
	SKDP_CB_STARTCHECK			equ				14

	SKDP_SR_READ				equ				1
	SKDP_SR_WRITE				equ				2
	SKDP_SR_EXEC				equ				4

	SKDP_CR_REBOOT				equ				1
	SKDP_CR_QUIT				equ				2
	SKDP_CR_RESTART				equ				4
	SKDP_CR_UPDATE				equ				8

	SKDP_CS_UNKNOWN				equ				0
	SKDP_CS_DONTCARE			equ				1
	SKDP_CS_STOPPED				equ				2
	SKDP_CS_READY				equ				3
	SKDP_CS_TIMEOUT				equ				4

	SYSLOGMODE_NONE				equ				0
	SYSLOGMODE_PASSIVE			equ				1
	SYSLOGMODE_ACTIVE			equ				2

	AF_INET						equ				2							; SOCKETADDRESS.nFamily

	SOCKETADDRESS				STRUC
		nFamily					DW				?
		nPort					DW				?
		nIp						DD				?
		nZero					DB				8 DUP(?)
	SOCKETADDRESS				ENDS

	SKDPTIMEINFO				STRUC
		nMSec					dw				?
		nDoW					db				?
		nSec					db				?
		nMin					db				?
		nHour					db				?
		nDay					db				?
		nMonth					db				?
		nYear					dw				?
		nReserved				dw				?
	SKDPTIMEINFO				ENDS

	SKDPVERSION					STRUC
		nVersionHi				dw				?
		nVersionLo				dw				?
		nUDPBlkSize				dw				?
		nMaxUDPBlk				db				?
		nMaxFile				db				?
		nChrSetLocal			db				?
		nChrSetRemote			db				?
		nReserved				db				14 dup(?)
		cVendor					db				SKDP_MAXNAMESIZE dup(?)
		cComputer				db				SKDP_MAXNAMESIZE dup(?)
		cUser					db				SKDP_MAXNAMESIZE dup(?)
	SKDPVERSION					ENDS

	SKDPTIME					STRUC
		nmSecSec				DW				?
		nMHDMY					DD				?
	SKDPTIME					ENDS

	SKDPFILEINFO				STRUC
		FileTime				SKDPTIME		<>
		nAttr					DW				?
		nSize					DD				?
	SKDPFILEINFO				ENDS

	SKDPBIGFILEINFO				STRUC
		FileTime				SKDPTIME		<>
		nAttr					DW				?
		nSizeLo					DD				?
		nSizeHi					DD				?
	SKDPBIGFILEINFO				ENDS

	SKDPFILEREQUEST				STRUC
		nHandle					DB				?
		nFlags					DB				?
		nBlocks					DB				?
		nReserved				DB				?
	SKDPFILEREQUEST				ENDS

	SKDPFILEREPLY				STRUC
		nHandle					DB				?
		nFlags					DB				?
		nBlocks					DB				?
		nReserved				DB				?
		nSizeLo					DD				?
		nSizeHi					DD				?
		nPosLo					DD				?
		nPosHi					DD				?
	SKDPFILEREPLY				ENDS

	SKDPSFVREQUEST				STRUC
		nSfv					DD				?
		nSize					DD				?
		nMaxSize				DD				?
		FTime					SKDPTIME		<>
		bFirst					DB				?
		nChrSet					DB				?
	SKDPSFVREQUEST				ENDS

	SKDPSFVREPLY				STRUC
		nSfv					DD				?
		nSize					DD				?
		FTime					SKDPTIME		<>
		bChanged				DB				?
		bReserved				DB				?
	SKDPSFVREPLY				ENDS

	SKDPOPENMODE				STRUC
		nMode					DB				?
		nChrSet					DB				?
		cFile					DB				SKDP_MAXPATH DUP(?)
	SKDPOPENMODE				ENDS

	SKDPIOMODE					STRUC
		nMode					DB				?
		nSize					DB				3 DUP(?)
		nSeek					DD				?
	SKDPIOMODE					ENDS

	SKDPBIGIOMODE				STRUC
		nMode					DB				?
		nSize					DB				3 DUP(?)
		nSeekLo					DD				?
		nSeekHi					DD				?
	SKDPBIGIOMODE				ENDS

	SKDPPACKET					STRUC
		Adr						SOCKETADDRESS	<>
		nLen					dd				?
		nError					DD				?
		nSysErr					DD				?
								UNION
		cUdp					db				UDP_MAXDATASIZE DUP(?)
								STRUC
		Hdr						SKDPHEADER		<>
								UNION
		cData					db				SKDP_MAXDATASIZE DUP(?)
		wData					dw				(SKDP_MAXDATASIZE / 2) DUP(?)
		dwData					dd				(SKDP_MAXDATASIZE / 4) DUP(?)
								ENDS
								ENDS
								ENDS
		nFill					dd				?
	SKDPPACKET					ENDS

	SKDP_MAXEVENTS				equ				3

	SKDPCONINFO					STRUC
		cName					DB				SKDP_MAXNAMESIZE DUP(?)
		nIp						DD				?
		bRstCheck				DD				?
		bRstError				DD				?
		nRstTime				DD				?
		nRstActCnt				DD				?
		nRstMaxCnt				DD				?
		nRstLastDay				DD				?
		nRstLastSec				DD				?
		nLastTick				DD				?
		nSysLog					DW				?
		nLogState				DB				?
		nState					DB				?
		nFlags					DW				?
		nReserved				DB				?
		nDirCnt					DB				?
		nDirs					DB				SKDP_MAXFOLDER DUP(?)
	SKDPCONINFO					ENDS

	SKDPFINDHDR					STRUC
		nBlk					dw				?
								UNION
		nCnt					dw				?
		nPkt					dw				?
								ENDS
	SKDPFINDHDR					ENDS

	SKDPFINDREQUEST				STRUC
		nBlk					dw				?
		nPkt					dw				?
		bDirs					db				?
		nChrSet					db				?
		cPath					db				SKDP_MAXPATH dup (?)
	SKDPFINDREQUEST				ENDS

	SKDPFINDREPLY				STRUC
		nBlk					dw				?
		nCnt					dw				?
		bLast					db				?
		nChrSet					db				?
								UNION
		FileInfo				SKDPFILEINFO	<>
		BigFileInfo				SKDPBIGFILEINFO	<>
		cPath					db				SKDP_MAXPATH dup (?)
								ENDS
	SKDPFINDREPLY				ENDS

	SKDPFINDDATA				STRUC
		hFind					dd				?
		nNextBlk				dw				?
		nChrSet					db				?
		bReady					db				?
		bFlags					db				?
		bIsCurrent				db				?
		bIsParent				db				?
		bReserved				db				?
		wfd						WIN32_FIND_DATA	<>
		cMask					db				SKDP_MAXPATH dup (?)
	SKDPFINDDATA				ENDS

	SKDPJOB						STRUC
		nClntIdx				DB				?
		nSrvrIdx				DB				?
		nJobID					DB				?
		nRcvBlkCnt				DB				?
		nSndBlkCnt				DB				?
		nRetry					DB				?
		nFlags					DW				?
		nReqID					DW				?
		nFunction				DW				?
		nTickStart				DD				?
		nTimeOut				DD				?
		nReqTOut				DD				?
		pActFile				DD				?
		pFiles					DD				SKDP_MAXFILES DUP(?)
		nRcvBlkState			LARGEINT		<>
		nSndBlkState			LARGEINT		<>
		nLastID					DW				?
		nSndRetry				DB				?
		bQuit					DB				?
		hThread					DD				?
		hEventUdp				DD				?
		hEventTest				DD				?
		nReserved				DW				?
		nConID					DB				?
		nDirCnt					DB				?
		nDirs					DB				2 * SKDP_MAXFOLDER DUP(?)
		nRcvEnd					DD				?
		nRcvLen					DD				?
		nSndLen					DD				?
		pRcvData				DD				?
		pSndData				DD				?
		hUserWnd				DD				?
		hUserEvent				DD				?
		pResult					DD				?
								UNION
		pUser					DD				?
		nUser					DD				?
								ENDS
		pFind					DD				?
		pSndChk					DD				?
		bRcvRdy					DB				?
		bTskRdy					DB				?
		nRcvErr					DB				?
		nSndErr					DB				?
		nSysErr					DD				?
		sPkt					SKDPPACKET		<>
		cData					DB				SKDP_MAXJOBDATASIZE DUP(?)
	SKDPJOB						ENDS

	NETINFO						STRUC
		nSkt					DD				?
		nIp						DD				?
		nNetMask				DD				?
		nBroadCast				DD				?
		nLocBroadCast			DD				?
		nPort					DW				?
		bWSA					DW				?
	NETINFO						ENDS

	SKDPINFO					STRUC
		UsrInf					USERINFO		<>
		NetInf					NETINFO			<>
		nSysLog					DW				?
		nDefDir					DB				?
		nDirCnt					DB				?
		nDirs					DB				SKDP_MAXFOLDER DUP(?)
		nConnections			DD				?
		pConInfo				DD				?
		pShareList				DD				?
		pRPkt					DD				?
		pSPkt					DD				?
		nTimerID				DD				?
		nTickStart				DD				?
		nTickCounter			DD				?
		nJobFree				DD				?
		nJobActive				DD				?
		nJobTimeOut				DD				?
		pCallBack				DD				?
		pJobs					DD				SKDP_MAXJOB DUP(?)
		nMaxJob					DD				?
		nTOut_Send				DD				?
		nTOut_Std				DD				?
		nTOut_Resend			DD				?
		nTOut_IO				DD				?
		nTOut_Find				DD				?
		nTOut_Req				DD				?
		nSndRetry				DD				?
		nRcvRetry				DD				?
		nDebug					DD				?
		nError					DD				?
		nSysErr					DD				?
		hMainWnd				DD				?
		hDlgWnd					DD				?
		bActive					DD				?
		bEnReStart				DD				?
		bEnReBoot				DD				?
		hThread					DD				?
		hEventPacket			DD				?
		hEventTimeOut			DD				?
		hEventTest				DD				?
	SKDPINFO					ENDS

EXTERNDEF C		g_SKDPInfo				:SKDPINFO

pSKDP_Callback	PROTO STDCALL :dword, :dword, :dword, :dword
pJobThreadProc	PROTO STDCALL :dword
