;********************************************************************
;* Copyright (c) 2012-14 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - skdp_jobs.asm											*
;********************************************************************
.586
.MODEL FLAT, stdcall
option casemap :none
option scoped

include skdp32.inc

.CODE

OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

Sleep	PROTO	STDCALL :DWORD

	_SizeTable				dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXNAMESIZE		; request
							dw		0, 0															; reply		SKDPFC_SRVRINIT
							dw		0, 0
							dw		0, 0															; reply		SKDPFC_SRVRDONE
							dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXNAMESIZE
							dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXNAMESIZE		; reply		SKDPFC_SRVRFIND
							dw		SIZE BYTE + SKDP_MINSTRSIZE, -1
							dw		0, 0															; reply		SKDPFC_MESSAGE
							dw		0, 0
							dw		0, 0															; reply		SKDPFC_ENDREQUEST
							dw		SIZE SKDPVERSION, SIZE SKDPVERSION
							dw		SIZE SKDPVERSION, SIZE SKDPVERSION								; reply		SKDPFC_VERSION
							dw		0, 1
							dw		SIZE SKDPTIMEINFO, SIZE SKDPTIMEINFO							; reply		SKDPFC_GETTIME
							dw		0, SIZE BYTE + SKDP_MAXPATH
							dw		SIZE DWORD, SIZE DWORD											; reply		SKDPFC_GETRIGHTS
							dw		0, 0
							dw		0, 0															; reply		SKDPFC_RESTART
							dw		0, 0
							dw		0, 0															; reply		SKDPFC_REBOOT
							dw		0, 0
							dw		0, 0															; reply		SKDPFC_QUIT
							dw		SIZE BYTE + 2 * SKDP_MINSTRSIZE, SIZE BYTE + 2 * SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_UPDATE
							dw		SIZE BYTE + 2 * SKDP_MINSTRSIZE, SIZE BYTE + 2 * SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_EXEC
							dw		SIZE SKDPFINDHDR, SIZE SKDPFINDREQUEST
							dw		SIZE SKDPFINDHDR, -1											; reply		SKDPFC_FINDFILE
							dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_DIRCREATE
							dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_DIRREMOVE
							dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXPATH
							dw		SIZE SKDPFILEINFO, SIZE SKDPBIGFILEINFO							; reply		SKDPFC_FILEINFO
							dw		SIZE WORD + SIZE BYTE + SKDP_MINSTRSIZE, SIZE WORD + SIZE BYTE + SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_SETFATTR
							dw		SIZE SKDPTIME + SIZE BYTE + SKDP_MINSTRSIZE, SIZE SKDPTIME + SIZE BYTE + SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_SETFDATE
							dw		SIZE WORD + 2 * SKDP_MINSTRSIZE, SIZE WORD + 2 * SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_FILERENAME
							dw		SIZE WORD + SKDP_MINSTRSIZE, SIZE WORD + SKDP_MAXPATH
							dw		0, 0															; reply		SKDPFC_FILEDELETE
							dw		SIZE SKDPFILEREQUEST, -1
							dw		SIZE SKDPFILEREPLY, -1											; reply		SKDPFC_FILEIO
							dw		SIZE SKDPSFVREQUEST + SKDP_MINSTRSIZE, SIZE SKDPSFVREQUEST + SKDP_MAXPATH
							dw		SIZE SKDPSFVREPLY, -1											; reply		SKDPFC_SFVREAD
							dw		SIZE DWORD + SIZE WORD + 2 * SIZE BYTE + SKDP_MINSTRSIZE, -1
							dw		SIZE SKDPFILEINFO, SIZE SKDPFILEINFO							; reply		SKDPFC_CREATEDATA
							dw		SIZE BYTE + 3 * SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXPATH + 2 * SKDP_MAXSTRSIZE
							dw		SIZE BYTE + SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXSTRSIZE		; reply		SKDPFC_READKEY
							dw		SIZE BYTE + 4 * SKDP_MINSTRSIZE, SIZE BYTE + SKDP_MAXPATH + 3 * SKDP_MAXSTRSIZE
							dw		0, 0															; reply		SKDPFC_WRITEKEY
	SKDPFC_LASTTESTED		equ		SKDPFC_WRITEKEY
;***************************************************************
;LPSKDPJOB __stdcall SKDP_JobInUse(INT32 nJobIdx);
	SKDP_JobInUse			PROC	Par1: DWORD
	_arglen					=		4
	_pushlen				=		0
	@@nJobIdx				equ		dword ptr [esp + _pushlen + 4]

							xor		eax, eax
							mov		edx, @@nJobIdx
							dec		dl
							cmp		dl, byte ptr g_SKDPInfo.nMaxJob
							jae		@@1
							bt 		g_SKDPInfo.nJobFree, edx
							jc		@@1
							mov		eax, g_SKDPInfo.pJobs[4 * edx]
			@@1:			ret		_arglen
	SKDP_JobInUse			ENDP
;***************************************************************
;INT32 __stdcall SKDP_JobValid(LPSKDPJOB lpJob, BOOL bForRequest);
	SKDP_JobValid			PROC	Par1: DWORD, Par2: DWORD
	_arglen					=		8
	_pushlen				=		0
	@@bForRequest			equ		dword ptr [esp + _pushlen + 8]
	@@lpJob					equ		dword ptr [esp + _pushlen + 4]

							xor		eax, eax
							mov		ecx, @@lpJob
							test	ecx, ecx
							jz		@@2
							movzx	edx, [ecx].SKDPJOB.nClntIdx
							dec		dl
							cmp		dl, byte ptr g_SKDPInfo.nMaxJob
							jae		@@2
							bt 		g_SKDPInfo.nJobFree, edx
							jc		@@2
							cmp		ecx, g_SKDPInfo.pJobs[4 * edx]
							jne		@@2
							cmp		@@bForRequest, eax
							je		@@3
							test	[ecx].SKDPJOB.nFlags, SKDPFL_REPLY
							jz		@@1
							mov		al, SKDPERR_BADJOBTYPE
							jmp		@@3
			@@1:			cmp		[ecx].SKDPJOB.bTskRdy, al
							jne		@@3
							mov		al, SKDPERR_JOBINUSE
							jmp		@@3
			@@2:			mov		al, SKDPERR_INVALIDJOB
			@@3:			ret		_arglen
	SKDP_JobValid			ENDP
;***************************************************************
; in:
; edi: --> SKDPJOB
;  ax: nPort
; ecx: nIpVal
;  dx: nFlags
	_pSKDP_InitJob			PROC	PRIVATE
; nID, nClntIdx, pInfo initialized at allocation
							push	ebx
							push	esi
							push	eax
							push	ecx
							push	edx
							test	[edi].SKDPJOB.nFlags, SKDPFL_REPLY
							jnz		@@02
							mov		[edi].SKDPJOB.nRcvErr, SKDPERR_JOBREINITIALIZED
							mov		[edi].SKDPJOB.bRcvRdy, TRUE
							invoke	GetTickCount
							mov		esi, eax
			@@01:			cmp		[edi].SKDPJOB.bTskRdy, FALSE
							jne		@@02
							invoke	Sleep, 0
							invoke	GetTickCount
							sub		eax, esi
							cmp		eax, 1000
							jb		@@01
							cmp		[edi].SKDPJOB.bTskRdy, TRUE
			@@02:			mov		eax, [edi].SKDPJOB.pUser
							test	eax, eax
							jz		@@03
							invoke	FreeMem, eax
			@@03:			mov		ebx, SKDP_MAXFILES
							mov		eax, [edi].SKDPJOB.pActFile
							test	eax, eax
							jz		@@04
							invoke	FClose, eax
			@@04:			test	ebx, ebx
							jz		@@05
							dec		ebx
							mov		eax, [edi + 4 * ebx].SKDPJOB.pFiles
							test	eax, eax
							jz		@@04
							invoke	FClose, eax
							mov		[edi + 4 * ebx].SKDPJOB.pFiles, 0
							jmp		@@04
			@@05:			mov		ebx, [edi].SKDPJOB.pFind
							test	ebx, ebx
							jz		@@07
							mov		eax, [ebx].SKDPFINDDATA.hFind
							cmp		eax, -1
							je		@@06
							invoke	FindClose, eax
			@@06:			invoke	FreeMem, ebx
			@@07:			pop		edx
							pop		ecx
							pop		eax
							mov		[edi].SKDPJOB.sPkt.Adr.nFamily, AF_INET
							mov		[edi].SKDPJOB.sPkt.Adr.nPort, ax
							mov		[edi].SKDPJOB.sPkt.Adr.nIp, ecx
							and		dx, SKDPFL_TYPEMASK
							mov		[edi].SKDPJOB.nFlags, dx
							movzx	ecx, [edi].SKDPJOB.nClntIdx
							dec		cl
							btr		g_SKDPInfo.nJobActive, ecx
							btr		g_SKDPInfo.nJobTimeOut, ecx
							mov		al, [edi].SKDPJOB.nJobID
							inc		al
							and		al, 007h
							shl		cl, 3
							or		al, cl
							mov		[edi].SKDPJOB.nJobID, al
							xor		eax, eax
							mov		[edi].SKDPJOB.nSrvrIdx, al					; 0
							mov		[edi].SKDPJOB.nRcvBlkCnt, al				; 0
							mov		[edi].SKDPJOB.nSndBlkCnt, al				; 0
							mov		[edi].SKDPJOB.nRetry, al					; 0
							mov		[edi].SKDPJOB.nReqID, ax					; 0
							mov		[edi].SKDPJOB.nFunction, ax					; SKDPFC_SRVRINIT
							mov		[edi].SKDPJOB.nTickStart, eax				; 0
							mov		[edi].SKDPJOB.nTimeOut, eax					; 0
							mov		[edi].SKDPJOB.nReqTOut, eax					; 0
							mov		[edi].SKDPJOB.nRcvBlkState.u32lo, eax		; 0
							mov		[edi].SKDPJOB.nRcvBlkState.u32hi, eax		; 0
							mov		[edi].SKDPJOB.nSndBlkState.u32lo, eax		; 0
							mov		[edi].SKDPJOB.nSndBlkState.u32hi, eax		; 0
							mov		[edi].SKDPJOB.nLastID, ax					; 0
							mov		[edi].SKDPJOB.nSndRetry, al					; 0
							mov		[edi].SKDPJOB.bQuit, al						; 0
							mov		[edi].SKDPJOB.nConID, -1					; 0
							mov		[edi].SKDPJOB.nDirCnt, al					; 0
							mov		[edi].SKDPJOB.nRcvEnd, eax					; 0
							mov		[edi].SKDPJOB.nRcvLen, eax					; 0
							mov		[edi].SKDPJOB.nSndLen, eax					; 0
							mov		[edi].SKDPJOB.pRcvData, eax					; 0
							mov		[edi].SKDPJOB.pSndData, eax					; 0
							mov		[edi].SKDPJOB.hUserWnd, eax					; NULL
							mov		[edi].SKDPJOB.pResult, eax					; NULL
							mov		[edi].SKDPJOB.pUser, eax					; = nUser = NULL(0)
							mov		[edi].SKDPJOB.pFind, eax					; NULL
							mov		[edi].SKDPJOB.pSndChk, eax					; NULL
							mov		[edi].SKDPJOB.nRcvErr, al					; 0
							mov		[edi].SKDPJOB.nSndErr, al					; 0
							mov		[edi].SKDPJOB.nSysErr, eax					; 0
							cmp		[edi].SKDPJOB.sPkt.Adr.nIp, eax
							je		@@16
							lea		ebx, [edi].SKDPJOB.nDirs
							mov		esi, g_SKDPInfo.pConInfo
							mov		ecx, g_SKDPInfo.nConnections
							test	ecx, ecx
							jz		@@10
							mov		eax, [edi].SKDPJOB.sPkt.Adr.nIp
							xor		edx, edx
			@@08:			cmp		eax, [esi].SKDPCONINFO.nIp
							jne		@@09
							movzx	ecx, [esi].SKDPCONINFO.nDirCnt
							mov		eax, dword ptr [esi].SKDPCONINFO.nDirs
							mov		[ebx], eax
							mov		[edi].SKDPJOB.nConID, dl
							jmp		@@10
			@@09:			lea		esi, [esi + SIZE SKDPCONINFO]
							inc		edx
							loop	@@08
			@@10:			mov		[edi].SKDPJOB.nDirCnt, cl
							add		ebx, ecx
							mov		edx, -1
							test	ecx, ecx
							jz		@@11
							movzx	edx, g_SKDPInfo.nDefDir
			@@11:			movzx	ecx, g_SKDPInfo.nDirCnt							; >= 1
			@@12:			movzx	eax, g_SKDPInfo.nDirs[ecx - 1]
							cmp		eax, edx
							je		@@15
							movzx	esi, [edi].SKDPJOB.nDirCnt
							test	esi, esi
							jz		@@14
			@@13:			cmp		al, [edi + esi - 1].SKDPJOB.nDirs
							je		@@15
							dec		esi
							jnz		@@13
			@@14:			mov		[ebx], eax
							inc		[edi].SKDPJOB.nDirCnt
							inc		ebx
			@@15:			loop	@@12
			@@16:			pop		esi
							pop		ebx
							ret
	_pSKDP_InitJob			ENDP
;***************************************************************
; in:
; eax: mode
; edi: job index
; out
; edi: --> SKDPJOB / NULL
; al = error
	_pStartThread			PROC	PRIVATE
							push	ebx
							push	esi
							mov		ebx, eax
							invoke	CreateEvent, 0, TRUE, 0, 0
							test	eax, eax
							jz		@@1
							mov		esi, eax
							invoke	CreateEvent, 0, TRUE, 0, 0
							test	eax, eax
							jnz		@@2
							invoke	CloseHandle, esi
			@@1:			mov		al, SKDPERR_CREATEEVENT
							jmp		@@3
			@@2:			xchg	eax, ebx
							push	edi
							mov		edi, g_SKDPInfo.pJobs[4 * edi]
							mov		[edi].SKDPJOB.nFlags, ax
							invoke	SimpleThread, pJobThreadProc, edi
							pop		ecx
							test	eax, eax
							jnz		@@4
							invoke	CloseHandle, ebx
							invoke	CloseHandle, esi
							mov		al, SKDPERR_THREADSTART
			@@3:			xor		edi, edi
							jmp		@@5
			@@4:			mov		[edi].SKDPJOB.hThread, eax
							mov		[edi].SKDPJOB.hEventUdp, ebx
							mov		[edi].SKDPJOB.hEventTest, esi
							btr		g_SKDPInfo.nJobFree, ecx
							xor		eax, eax
			@@5:			pop		esi
							pop		ebx
							ret
	_pStartThread			ENDP
;***************************************************************
;LPSKDPJOB __stdcall SKDP_GetJob(HWND hWnd, HANDLE hEvent, INT32 nIpVal, INT32 nPort, LPINT32 lpError);
	SKDP_GetJob				PROC	Par1: DWORD, Par2: DWORD, Par3: DWORD, Par4: DWORD, Par5: DWORD
	_arglen					=		20
	_pushlen				=		8
	@@lpError				equ		dword ptr [esp + _pushlen + 20]
	@@nPort					equ		dword ptr [esp + _pushlen + 16]
	@@nIpVal				equ		dword ptr [esp + _pushlen + 12]
	@@hEvent				equ		dword ptr [esp + _pushlen + 8]
	@@hWnd					equ		dword ptr [esp + _pushlen + 4]

							push	ebx
							push	edi
							invoke	LockThread, _SKDP_LOCK
							xor		ebx, ebx
							bsf		edi, g_SKDPInfo.nJobFree
							jnz		@@1
							xor		edi, edi
							mov		bl, SKDPERR_JOBTABLEFULL
							jmp		@@4
			@@1:			mov		eax, SKDPFL_REQUEST
							call	_pStartThread
							test	eax, eax
							jz		@@2
							mov		bl, al
							jmp		@@4
			@@2:			mov		[edi].SKDPJOB.bTskRdy, TRUE
							mov		eax, @@nPort
							test	eax, eax
							jnz		@@3
							mov		ax, g_SKDPInfo.NetInf.nPort
			@@3:			mov		ecx, @@nIpVal
							mov		dx, SKDPFL_REQUEST
							call	_pSKDP_InitJob
							mov		eax, @@hWnd
							mov		[edi].SKDPJOB.hUserWnd, eax
							mov		eax, @@hEvent
							mov		[edi].SKDPJOB.hUserEvent, eax
			@@4:			invoke	UnLockThread, _SKDP_LOCK
							test	g_SKDPInfo.nDebug, SKDP_DBGM_JOB
							jz		@@5
							invoke	pSKDP_Callback, SKDP_CB_DBGGETJOB, ebx, edi, 0
			@@5:			mov		eax, edi
							mov		edi, @@lpError
							test	edi, edi
							jz		@@6
							mov		[edi], ebx
			@@6:			pop		edi
							pop		ebx
							ret		_arglen
	SKDP_GetJob				ENDP
;***************************************************************
;INT32 __stdcall SKDP_ResetJob(LPSKDPJOB lpJob, HWND hWnd, HANDLE hEvent, INT32 nIpVal, INT32 nPort);
	SKDP_ResetJob			PROC	Par1: DWORD, Par2: DWORD, Par3: DWORD, Par4: DWORD, Par5: DWORD
	_arglen					=		20
	_pushlen				=		4
	@@nPort					equ		dword ptr [esp + _pushlen + 20]
	@@nIpVal				equ		dword ptr [esp + _pushlen + 16]
	@@hEvent				equ		dword ptr [esp + _pushlen + 12]
	@@hWnd					equ		dword ptr [esp + _pushlen + 8]
	@@lpJob					equ		dword ptr [esp + _pushlen + 4]

							push	edi
							invoke	LockThread, _SKDP_LOCK
							mov		edi, @@lpJob
							invoke	SKDP_JobValid, edi, FALSE
							test	eax, eax
							jnz		@@3
							mov		eax, @@nPort
							test	eax, eax
							jnz		@@1
							mov		ax, [edi].SKDPJOB.sPkt.Adr.nPort
			@@1:			mov		ecx, @@nIpVal
							test	ecx, ecx
							jnz		@@2
							mov		ecx, [edi].SKDPJOB.sPkt.Adr.nIp
			@@2:			mov		dx, SKDPFL_REQUEST
							invoke	_pSKDP_InitJob
							mov		eax, @@hWnd
							mov		[edi].SKDPJOB.hUserWnd, eax
							mov		eax, @@hEvent
							mov		[edi].SKDPJOB.hUserEvent, eax
							xor		eax, eax
			@@3:			invoke	UnLockThread, _SKDP_LOCK
							push	eax
							test	g_SKDPInfo.nDebug, SKDP_DBGM_JOB
							jz		@@4
							invoke	pSKDP_Callback, SKDP_CB_DBGRESETJOB, eax, edi, 0
			@@4:			pop		eax
							pop		edi
							ret		_arglen
	SKDP_ResetJob			ENDP
;;********************************************************************
;INT32 __stdcall SKDP_FreeJob(LPSKDPJOB lpJob);
	SKDP_FreeJob			PROC	Par1: DWORD
	_arglen					=		4
	_pushlen				=		12
	@@lpJob					equ		dword ptr [esp + _pushlen + 4]

							push	ebx
							push	esi
							push	edi
							invoke	LockThread, _SKDP_LOCK
							mov		edi, @@lpJob
							invoke	SKDP_JobValid, edi, FALSE
							test	eax, eax
							jnz		@@6
							xor		ecx, ecx									; eax = 0
							mov		dx, SKDPFL_REPLY
							invoke	_pSKDP_InitJob
							mov		ebx, [edi].SKDPJOB.hEventUdp
							test	ebx, ebx
							jz		@@5
							mov		[edi].SKDPJOB.bQuit, TRUE
							invoke	SetEvent, ebx
							invoke	GetTickCount
							mov		esi, eax
			@@1:			mov		ebx, [edi].SKDPJOB.hThread
							test	ebx, ebx
							jz		@@3
							invoke	GetTickCount
							sub		eax, esi
							cmp		eax, 1000
							jae		@@2
							invoke	Sleep, 0
							jmp		@@1
			@@2:			invoke	TerminateThread, ebx, -1
							mov		[edi].SKDPJOB.hThread, 0
							mov		ebx, SKDPERR_THREADKILLED
			@@3:			xor		eax, eax
							xchg	eax, [edi].SKDPJOB.hEventUdp
							test	eax, eax
							jz		@@4
							invoke	CloseHandle, eax
			@@4:			xor		eax, eax
							xchg	eax, [edi].SKDPJOB.hEventTest
							test	eax, eax
							jz		@@5
							invoke	CloseHandle, eax
			@@5:			movzx	eax, [edi].SKDPJOB.nClntIdx
							dec		al
							bts		g_SKDPInfo.nJobFree, eax
							mov		eax, ebx
			@@6:			invoke	UnLockThread, _SKDP_LOCK
							push	eax
							test	g_SKDPInfo.nDebug, SKDP_DBGM_JOB
							jz		@@7
							invoke	pSKDP_Callback, SKDP_CB_DBGFREEJOB, eax, edi, 0
			@@7:			pop		eax
							pop		edi
							pop		esi
							pop		ebx
							ret		_arglen
	SKDP_FreeJob			ENDP
;***************************************************************
;LPSKDPJOB __stdcall pSKDP_FindJob(LPINT32 lpError);
	pSKDP_FindJob			PROC	Par1: DWORD
	_arglen					=		4
	_pushlen				=		16
	@@lpError				equ		dword ptr [esp + _pushlen + 4]
							push	ebp
							push	ebx
							push	esi
							push	edi
							xor		ebx, ebx										; SKDPERR_NONE
							mov		ecx, SIZE SKDPHEADER
							mov		esi, g_SKDPInfo.pRPkt
							cmp		ecx, [esi].SKDPPACKET.nLen
							ja		@@01
							cmp		[esi].SKDPPACKET.Hdr.nID, SKDP_MSGID
							je		@@02
			@@01:			mov		bl, SKDPERR_BADPACKET
							jmp		@@60
			@@02:			sub		[esi].SKDPPACKET.nLen, ecx
							xor		eax, eax
			@@03:			add		al, [esi + ecx - 1].SKDPPACKET.cUdp
							loop	@@03
							test	al, al
							jz		@@04
							mov		bl, SKDPERR_BADCHKSUM
							jmp		@@60
			@@04:			mov		edx, dword ptr [esi].SKDPPACKET.Hdr.nClntIdx	; dl = nClntIdx, dh = nSrvrIdx, nJobID, nFlags
							shld	eax, edx, 16									; al = nJobID, ah = nFlags
							movzx	ecx, [esi].SKDPPACKET.Hdr.nBlkCnt				; nBlkCnt, nBlkID
							shr		ecx, 1
							jz		@@10
							cmp		cl, SKDP_MAXPACKETCOUNT
							ja		@@10
							movzx	ebp, [esi].SKDPPACKET.Hdr.nBlkID
							cmp		ebp, ecx
							jb		@@05
							mov		bl, SKDPERR_BADBLKID
							jmp		@@60
			@@05:			imul	ebp, SKDP_MAXDATASIZE
							mov		edi, dword ptr [esi].SKDPPACKET.Hdr.nBlkOfs
							and		edi, 00001FFFFh
							cmp		edi, ebp
							jbe		@@06
							mov		bl, SKDPERR_BADBLKOFS
							jmp		@@60
			@@06:			mov		edi, [esi].SKDPPACKET.nLen
							cmp		edi, SKDP_MAXDATASIZE
							jbe		@@07
							mov		bl, SKDPERR_BADBLKLEN
							jmp		@@60
			@@07:			test	ah, SKDPFL_RESEND
							jz		@@11
							cmp		edi, SIZE QWORD
							je		@@09
			@@08:			mov		bl, SKDPERR_BADDATALEN
							jmp		@@60
			@@09:			cmp		cl, 1
							je		@@11
			@@10:			mov		bl, SKDPERR_BADBLKCNT
							jmp		@@60
			@@11:			movzx	ebp, [esi].SKDPPACKET.Hdr.nFunction
							test	ah, SKDPFL_BROADCAST
							jz		@@15
							cmp		cl, 1
							jne		@@10
							test	ah, SKDPFL_REPLY or SKDPFL_RESEND or SKDPFL_RETRY
							jnz		@@12
							cmp		bp, SKDPFC_MESSAGE
							jbe		@@13
			@@12:			mov		bl, SKDPERR_INVALIDFLAGS
							jmp		@@60
			@@13:			test	dl, dl
							jnz		@@17
							test	dh, dh
							jnz		@@14
							lea		ebp, _SizeTable[8 * ebp]
							movsx	eax, word ptr [ebp]
							movsx	edx, word ptr [ebp + SIZE WORD]
							test	eax, eax
							js		@@61
							cmp		edi, eax
							jb		@@08
							test	edx, edx
							js		@@61
							cmp		edi, edx
							ja		@@08
							jmp		@@61
			@@14:			mov		bl, SKDPERR_BADJOBIDX
							jmp		@@60
			@@15:			cmp		bp, SKDPFC_MESSAGE
							jae		@@16
							cmp		bp, SKDPFC_SRVRFIND
							jb		@@12
							cmp		ah, SKDPFL_REPLY
							jne		@@12
							test	dl, dl
							jnz		@@17
							test	dh, dh
							jnz		@@14
							cmp		edi, SIZE BYTE + SKDP_MINSTRSIZE
							jb		@@08
							cmp		edi, SIZE BYTE + SKDP_MAXNAMESIZE
							ja		@@08
							jmp		@@61
			@@16:			test	dl, dl
							jnz		@@18
			@@17:			mov		bl, SKDPERR_BADSRVRIDX
							jmp		@@60
			@@18:			cmp		dh, byte ptr g_SKDPInfo.nMaxJob								; nSrvrIdx
							ja		@@14
							mov		ebp, g_SKDPInfo.nJobFree
							movzx	edi, dh
							test	edi, edi
							jnz		@@20
							test	ah, SKDPFL_REPLY or SKDPFL_RESEND
							jnz		@@14
							not		ebp
							mov		cl, byte ptr g_SKDPInfo.nMaxJob
							cmp		cl, SKDP_MAXJOB												; = 32
							je		@@19
							mov		edi, -1
							shl		edi, cl
							not		edi
							and		ebp, edi
			@@19:			bsf		edi, ebp
							jz		@@26
							btr		ebp, edi
							mov		edi, g_SKDPInfo.pJobs[4 * edi]
							test	[edi].SKDPJOB.nFlags, SKDPFL_REPLY
							jz		@@19
							mov		ecx, [esi].SKDPPACKET.Adr.nIp
							cmp		ecx, [edi].SKDPJOB.sPkt.Adr.nIp
							jne		@@19
							mov		cx, [esi].SKDPPACKET.Adr.nPort
							cmp		cx, [edi].SKDPJOB.sPkt.Adr.nPort
							jne		@@19
							cmp		dl, [edi].SKDPJOB.nSrvrIdx
							jne		@@19
							cmp		al, [edi].SKDPJOB.nJobID
							jne		@@19
							mov		ebp, dword ptr [esi].SKDPPACKET.Hdr.nReqID					; nReqID, nFunction
							jmp		@@34
			@@20:			dec		edi
							bt		ebp, edi
			 				jnc		@@21
							mov		bl, SKDPERR_JOBRELEASED
							jmp		@@25
			@@21:			mov		edi, g_SKDPInfo.pJobs[4 * edi]
							mov		ecx, [esi].SKDPPACKET.Adr.nIp
							cmp		ecx, [edi].SKDPJOB.sPkt.Adr.nIp
							je		@@22
							mov		bl, SKDPERR_IPMISMATCH
							jmp		@@25
			@@22:			mov		cx, [esi].SKDPPACKET.Adr.nPort
							cmp		cx, [edi].SKDPJOB.sPkt.Adr.nPort
							je		@@23
							mov		bl, SKDPERR_PORTMISMATCH
							jmp		@@25
			@@23:			mov		cx, [edi].SKDPJOB.nFlags
							xor		cl, ah
							and		cl, SKDPFL_REPLY
							jnz		@@24
							mov		bl, SKDPERR_JOBTYPEMISMATCH
							jmp		@@25
			@@24:			cmp		al, [edi].SKDPJOB.nJobID
							je		@@32
							mov		bl, SKDPERR_JOBIDMISMATCH
			@@25:			test	ah, SKDPFL_REPLY or SKDPFL_RESEND
							jnz		@@60
							cmp		[esi].SKDPPACKET.Hdr.nFunction, SKDPFC_ENDREQUEST
							jne		@@26
							cmp		ah, SKDPFL_RETRY
							jne		@@60
							xor		ebx, ebx
							jmp		@@61
			@@26:			xor		ebx, ebx
							bsf		edi, g_SKDPInfo.nJobFree
							jnz		@@28
							mov		bl, SKDPERR_JOBTABLEFULL
			@@27:			xor		edi, edi
							jmp		@@30
			@@28:			mov		eax, SKDPFL_REPLY
							call	_pStartThread
							test	eax, eax
							jz		@@29
							mov		bl, al
							jmp		@@30
			@@29:			mov		ax, [esi].SKDPPACKET.Adr.nPort
							mov		ecx, [esi].SKDPPACKET.Adr.nIp
							mov		dx, SKDPFL_REPLY
							invoke	_pSKDP_InitJob											; ecx = IP
							xor		eax, eax
							mov		[edi].SKDPJOB.bRcvRdy, al								; 0
							mov		[edi].SKDPJOB.bTskRdy, al								; 0
							mov		al, [esi].SKDPPACKET.Hdr.nClntIdx
							mov		ah, [esi].SKDPPACKET.Hdr.nJobID
							mov		word ptr [edi].SKDPJOB.nSrvrIdx, ax						; nSrvrIdx, nJobID
							mov		eax, dword ptr [esi].SKDPPACKET.Hdr.nReqID				; nReqID, nFunction
							mov		ebp, eax
							dec		ax
							mov		[edi].SKDPJOB.nLastID, ax
			@@30:			test	g_SKDPInfo.nDebug, SKDP_DBGM_JOB
							jz		@@31
							invoke	pSKDP_Callback, SKDP_CB_DBGREPLYJOB, ebx, edi, 0
			@@31:			test	edi, edi
							jz		@@62
							jmp		@@37
			@@32:			mov		ebp, dword ptr [esi].SKDPPACKET.Hdr.nReqID				; nReqID, nFunction
							test	ah, SKDPFL_RESEND
							jz		@@33
							cmp		bp, [edi].SKDPJOB.nReqID
							jne		@@40
							shr		ebp, 16
							cmp		bp, [edi].SKDPJOB.nFunction
							jne		@@42
							mov		cl, [edi].SKDPJOB.nSrvrIdx
							cmp		dl, cl
							jne		@@45
							test	[edi].SKDPJOB.nFlags, SKDPFL_MULTIBLK
							jz		@@12
							movzx	ecx, [edi].SKDPJOB.bRcvRdy							; SKDPFL_REPLY = 1 & bRcvRdy = 0	or
							xor		cl, ah												; SKDPFL_REPLY = 0 & bRcvRdy = 1
							and		cl, SKDPFL_REPLY
							jz		@@12
							mov		eax, [esi].SKDPPACKET.dwData
							mov		[edi].SKDPJOB.nSndBlkState.u32lo, eax
							mov		eax, [esi + 4].SKDPPACKET.dwData
							mov		[edi].SKDPJOB.nSndBlkState.u32hi, eax
							jmp		@@62
			@@33:			test	ah, SKDPFL_REPLY
							jnz		@@39
; Reply job. Test request
							mov		cl, [edi].SKDPJOB.nSrvrIdx
							cmp		dl, cl
							je		@@34
							mov		bl, SKDPERR_SRVRIDXMISMATCH							; Without reject
							jmp		@@62
			@@34:			cmp		bp, [edi].SKDPJOB.nReqID
							jne		@@36
							shr		ebp, 16
							cmp		bp, [edi].SKDPJOB.nFunction
							je		@@35
							mov		bl, SKDPERR_FUNCTIONMISMATCH						; Without reject
							jmp		@@62
			@@35:			mov		cl, [esi].SKDPPACKET.Hdr.nBlkCnt
							shr		cl, 1
							cmp		cl, [edi].SKDPJOB.nRcvBlkCnt
							je		@@50
							mov		bl, SKDPERR_BLKCNTMISMATCH							; Without reject
							jmp		@@62
			@@36:			mov		[edi].SKDPJOB.bRcvRdy, FALSE
							mov		[edi].SKDPJOB.bTskRdy, FALSE
							and		[edi].SKDPJOB.nFlags, SKDPFL_TYPEMASK
			@@37:			mov		dword ptr [edi].SKDPJOB.nReqID, ebp					; nReqID, nFunction
							lea		edx, [edi].SKDPJOB.cData
							lea		eax, [edx + SKDP_MAXDATASIZE]
							mov		cl, [esi].SKDPPACKET.Hdr.nBlkCnt
							shr		cl, 1
							cmp		cl, 1
							je		@@38
							xchg	eax, edx
			@@38:			mov		[edi].SKDPJOB.pRcvData, edx
							mov		[edi].SKDPJOB.pSndData, eax
							jmp		@@47
; Request job. Test reply
			@@39:			cmp		bp, [edi].SKDPJOB.nReqID
							je		@@41
			@@40:			mov		bl, SKDPERR_REQIDMISMATCH
							jmp		@@60
			@@41:			shr		ebp, 16
							cmp		bp, [edi].SKDPJOB.nFunction
							je		@@43
			@@42:			mov		bl, SKDPERR_FUNCTIONMISMATCH
							jmp		@@60
			@@43:			movzx	ebx, [esi].SKDPPACKET.Hdr.nError
							test	ebx, ebx
							jnz		@@55
							mov		ch, [edi].SKDPJOB.nRcvBlkCnt
							mov		cl, [esi].SKDPPACKET.Hdr.nBlkCnt
							shr		cl, 1
							cmp		cl, ch
							je		@@44
							test	ch, ch
							jz		@@44
							mov		bl, SKDPERR_BLKCNTMISMATCH
							jmp		@@60
			@@44:			cmp		dl, [edi].SKDPJOB.nSrvrIdx
							je		@@46
							test	[edi].SKDPJOB.nFlags, SKDPFL_WAITING
							jnz		@@46
			@@45:			mov		bl, SKDPERR_SRVRIDXMISMATCH
							jmp		@@62
			@@46:			and		[edi].SKDPJOB.nFlags, NOT SKDPFL_WAITING
							mov		[edi].SKDPJOB.nSrvrIdx, dl
							test	ch, ch
							jnz		@@50
			@@47:			mov		[edi].SKDPJOB.nRcvBlkCnt, cl
							xor		eax, eax
							mov		[edi].SKDPJOB.nRcvLen, eax
							mov		[edi].SKDPJOB.nRcvEnd, eax
							mov		edx, eax
							cmp		cl, 64
							jae		@@49
							dec		edx
							cmp		cl, 32
							je		@@49
							jb		@@48
							sub		cl, 32
							shl		edx, cl
							jmp		@@49
			@@48:			mov		eax, edx
							shl		eax, cl
			@@49:			mov		[edi].SKDPJOB.nRcvBlkState.u32lo, eax
							mov		[edi].SKDPJOB.nRcvBlkState.u32hi, edx
			@@50:			movzx	ecx, [esi].SKDPPACKET.Hdr.nBlkID
							bts		[edi].SKDPJOB.nRcvBlkState.u32lo, ecx
							jc		@@56												; No error, only reject - duplicated block
							mov		eax, dword ptr [esi].SKDPPACKET.Hdr.nBlkOfs
							and		eax, 00001FFFFh
							mov		edx, eax
							mov		ecx, [esi].SKDPPACKET.nLen
							add		[edi].SKDPJOB.nRcvLen, ecx
							add		eax, ecx
							cmp		[edi].SKDPJOB.nRcvEnd, eax
							jae		@@51
							mov		[edi].SKDPJOB.nRcvEnd, eax
			@@51:			push	esi
							push	edi
	_pushlen				=		24
							mov		edi, [edi].SKDPJOB.pRcvData
							lea		esi, [esi].SKDPPACKET.cData
							lea		edi, [edi + edx]
							mov		eax, ecx
							shr		ecx, 2
							and		eax, 3
							rep		movsd
							mov		ecx, eax
							rep		movsb
							pop		edi
							pop		esi
	_pushlen				=		16
							cmp		[edi].SKDPJOB.nRcvBlkState.u32lo, -1
							jne		@@58												; No error, only reject - not ready yet
							cmp		[edi].SKDPJOB.nRcvBlkState.u32hi, -1
							jne		@@58												; No error, only reject - not ready yet
							mov		eax, [edi].SKDPJOB.nRcvLen
							cmp		eax, [edi].SKDPJOB.nRcvEnd
							je		@@52
							mov		bl, SKDPERR_BADRCVLEN
							jmp		@@55
			@@52:			movzx	edx, [edi].SKDPJOB.nFunction
							cmp		edx, SKDPFC_LASTTESTED
							ja		@@55
							lea		edx, _SizeTable[8 * edx]
							test	[edi].SKDPJOB.nFlags, SKDPFL_REPLY
							jnz		@@53
							lea		edx, [edx + 2 * SIZE WORD]
			@@53:			movsx	ecx, word ptr [edx]
							movsx	edx, word ptr [edx + SIZE WORD]
							test	ecx, ecx
							js		@@55
							cmp		eax, ecx
							jb		@@54
							test	edx, edx
							js		@@55
							cmp		eax, edx
							jbe		@@55
			@@54:			mov		bl, SKDPERR_BADDATALEN
			@@55:			mov		[edi].SKDPJOB.nRcvErr, bl
							mov		[edi].SKDPJOB.bRcvRdy, TRUE
							test	[edi].SKDPJOB.nFlags, SKDPFL_REPLY
							jnz		@@57
							movzx	ecx, [edi].SKDPJOB.nClntIdx
							dec		cl
							btr		g_SKDPInfo.nJobActive, ecx
			@@56:			or		ebx, SKDPERRFL_REJECT
							jmp		@@62
			@@57:			mov		eax, g_SKDPInfo.nTOut_Req
							or		[edi].SKDPJOB.nFlags, SKDPFL_WAITING
							xor		edx, edx
							movzx	ecx, [edi].SKDPJOB.nReqID
							cmp		cx, [edi].SKDPJOB.nLastID
							je		@@59
							mov		[edi].SKDPJOB.nSndLen, edx
							mov		[edi].SKDPJOB.nSndErr, dl
							jmp		@@59
			@@58:			mov		eax, g_SKDPInfo.nTOut_Resend
							or		ebx, SKDPERRFL_REJECT
							mov		edx, g_SKDPInfo.nSndRetry
			@@59:			mov		[edi].SKDPJOB.nRetry, dl
							movzx	ecx, [edi].SKDPJOB.nClntIdx
							dec		cl
							mov		[edi].SKDPJOB.nTimeOut, eax
							mov		eax, g_SKDPInfo.nTickCounter
							mov		[edi].SKDPJOB.nTickStart, eax
							bts		g_SKDPInfo.nJobActive, ecx
							jmp		@@62
			@@60:			or		ebx, SKDPERRFL_REJECT
			@@61:			xor		edi, edi
			@@62:			mov		eax, @@lpError
							test	eax, eax
							jz		@@63
							mov		[eax], ebx
			@@63:			test	g_SKDPInfo.nDebug, SKDP_DBGM_RCV
							jz		@@64
							invoke	pSKDP_Callback, SKDP_CB_DBGRECEIVE, ebx, edi, esi
			@@64:			test	edi, edi
							jz		@@65
							movzx	eax, [edi].SKDPJOB.nConID
							cmp		al, 0
							jl		@@65
							imul	edx, eax, SIZE SKDPCONINFO
							add		edx, g_SKDPInfo.pConInfo
							cmp		[edx].SKDPCONINFO.nSysLog, SYSLOGMODE_NONE
							je		@@65
							mov		ebx, g_SKDPInfo.nTickCounter
							mov		[edx].SKDPCONINFO.nLastTick, ebx
							mov		[edx].SKDPCONINFO.nState, SKDP_CS_READY
							cmp		[edx].SKDPCONINFO.nLogState, SKDP_CS_READY
							je		@@65
							invoke	pSKDP_Callback, SKDP_CB_LIVE, eax, edi, esi
			@@65:			mov		eax, edi
							pop		edi
							pop		esi
							pop		ebx
							pop		ebp
							ret		_arglen
	pSKDP_FindJob			ENDP

END
