;********************************************************************
;* Copyright (c) 2012 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - skdp_utils.asm										*
;********************************************************************
.586
.MODEL FLAT, stdcall
option casemap :none
option scoped

include skdp32.inc

.CODE

OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE

;***************************************************************
;void __stdcall pSKDP_TimerProc(LPVOID lpParam);
	pSKDP_TimerProc			PROC	Par1: DWORD
	_arglen					=		4
	_pushlen				=		8

							push	esi
							push	edi
							mov		esi, g_SKDPInfo.nTickCounter
							mov		edi, g_SKDPInfo.nJobTimeOut
							test	edi, edi
							jnz		@@4
							invoke	TryLockThread, _SKDP_LOCK
							test	eax, eax
							jz		@@4
							push	ebx
	_pushlen				=		12
							mov		ebx, g_SKDPInfo.nJobActive
			@@1:			bsf		eax, ebx
							jz		@@2
							btr		ebx, eax
							mov		ecx, g_SKDPInfo.pJobs[4 * eax]
							mov		edx, esi
							sub		edx, [ecx].SKDPJOB.nTickStart
							cmp		edx, [ecx].SKDPJOB.nTimeOut
							jb		@@1
							bts		edi, eax
							jmp		@@1
			@@2:			and		edi, g_SKDPInfo.nJobActive
							jz		@@3
							mov		g_SKDPInfo.nJobTimeOut, edi
							invoke	SetEvent, g_SKDPInfo.hEventTimeOut
			@@3:			pop		ebx
							invoke	UnLockThread, _SKDP_LOCK
	_pushlen				=		8
			@@4:			pop		edi
							pop		esi
							ret		_arglen
	pSKDP_TimerProc			ENDP
;***************************************************************
;void __stdcall SysTimeToSKDPTime(LPSKDPTIME lpSKDPTime, LPSYSTEMTIME lpSysTime);
	SysTimeToSKDPTime		PROC	Par1: DWORD, Par2: DWORD
	_arglen					=		8
	_pushlen				=		0

	@@lpSysTime				equ		dword ptr [esp + _pushlen + 8]
	@@lpSKDPTime			equ		dword ptr [esp + _pushlen + 4]

							mov		ecx, @@lpSysTime
							mov		dx, [ecx].SYSTEMTIME.wSecond
							shl		dx, 10
							or		dx, [ecx].SYSTEMTIME.wMilliseconds
							movzx	eax, [ecx].SYSTEMTIME.wYear
							shl		eax, 4
							or		ax, [ecx].SYSTEMTIME.wMonth
							shl		eax, 5
							or		ax, [ecx].SYSTEMTIME.wDay
							shl		eax, 5
							or		ax, [ecx].SYSTEMTIME.wHour
							shl		eax, 6
							or		ax, [ecx].SYSTEMTIME.wMinute
							mov		ecx, @@lpSKDPTime
							mov		[ecx].SKDPTIME.nmSecSec, dx
							mov		[ecx].SKDPTIME.nMHDMY, eax
							ret		_arglen
	SysTimeToSKDPTime		ENDP
;***************************************************************
;void __stdcall SKDPTimeToSysTime(LPSYSTEMTIME lpSysTime, LPSKDPTIME lpSKDPTime);
	SKDPTimeToSysTime		PROC	Par1: DWORD, Par2: DWORD
	_arglen					=		8
	_pushlen				=		4

	@@lpSKDPTime			equ		dword ptr [esp + _pushlen + 8]
	@@lpSysTime				equ		dword ptr [esp + _pushlen + 4]

							push	edi
							mov		ecx, @@lpSKDPTime
							mov		edi, @@lpSysTime
							mov		ax, [ecx].SKDPTIME.nmSecSec
							mov		dx, ax
							and		ax, 003FFh
							shr		dx, 10
							mov		[edi].SYSTEMTIME.wSecond, dx
							mov		[edi].SYSTEMTIME.wMilliseconds, ax
							mov		eax, [ecx].SKDPTIME.nMHDMY
							mov		edx, eax
							and		ax, 0003Fh
							mov		[edi].SYSTEMTIME.wMinute, ax
							shr		edx, 6
							mov		eax, edx
							and		ax, 0001Fh
							mov		[edi].SYSTEMTIME.wHour, ax
							shr		edx, 5
							mov		eax, edx
							and		ax, 0001Fh
							mov		[edi].SYSTEMTIME.wDay, ax
							shr		edx, 5
							mov		eax, edx
							and		ax, 0000Fh
							mov		[edi].SYSTEMTIME.wMonth, ax
							shr		edx, 4
							mov		[edi].SYSTEMTIME.wYear, dx
							xor		eax, eax
							mov		[edi].SYSTEMTIME.wDayOfWeek, ax
							pop		edi
							ret		_arglen
	SKDPTimeToSysTime		ENDP

END
