;********************************************************************
;* Copyright (c) 2011-15 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - bitops.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.CODE
;*********************************************************************
;BOOL __stdcall GetBit(LPVOID lpBuf, INT32 nBit);
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE
	GetBit					PROC	Par1:DWORD, Par2:DWORD
	_arglen					=		8
	_pushlen				=		0
	@@nBit					equ		dword ptr [esp + _pushlen + 8]
	@@lpBuf					equ		dword ptr [esp + _pushlen + 4]
							xor		eax, eax
							mov		edx, @@lpBuf
							test	edx, edx
							jz		@@1
							mov		ecx,  @@nBit
							mov		eax, ecx
							shr		eax, 5
							lea		edx, [edx + 4 * eax]
							and		ecx, 00000001Fh
							xor		eax, eax
							bt		[edx], ecx
							setc	al
			@@1:			ret		_arglen
	GetBit					ENDP
;*********************************************************************
;BOOL __stdcall SetBit(LPVOID lpBuf, INT32 nBit, INT32 nValue);
	SetBit					PROC	Par1:DWORD, Par2:DWORD, Par3:DWORD
	_arglen					=		12
	_pushlen				=		0
	@@nValue				equ		dword ptr [esp + _pushlen + 12]
	@@nBit					equ		dword ptr [esp + _pushlen + 8]
	@@lpBuf					equ		dword ptr [esp + _pushlen + 4]
							xor		eax, eax
							mov		edx, @@lpBuf
							test	edx, edx
							jz		@@4
							mov		ecx, @@nBit
							mov		eax, ecx
							shr		eax, 5
							lea		edx, [edx + 4 * eax]
							and		ecx, 00000001Fh
							mov		eax, @@nValue
							and		eax, 3
							jnz		@@1
							btr		[edx], ecx
							jmp		@@3
			@@1:			cmp		al, 1
							jne		@@2
							bts		[edx], ecx
							jmp		@@3
			@@2:			btc		[edx], ecx
			@@3:			setc	al
			@@4:			ret		_arglen
	SetBit					ENDP
;*********************************************************************
;INT32 __stdcall ScanBits(LPVOID lpBuf, INT32 nDWCnt);
	ScanBits				PROC	Par1:DWORD, Par2:DWORD
	_arglen					=		8
	_pushlen				=		0
	@@nDWCnt				equ		dword ptr [esp + _pushlen + 8]
	@@lpBuf					equ		dword ptr [esp + _pushlen + 4]
							xor		eax, eax
							mov		edx, @@lpBuf
							test	edx, edx
							jz		@@4
							mov		ecx, @@nDWCnt
							test	ecx, ecx
							jz		@@4
							push	ebx
	_pushlen				=		4
							xor		ebx, ebx
			@@1:			bsf		eax, [edx + 4 * ebx]
							jnz		@@2
							inc		ebx
							loop	@@1
							xor		eax, eax
							jmp		@@3
			@@2:			shl		ebx, 5
							lea		eax, [eax + ebx + 1]
			@@3:			pop		ebx
	_pushlen				=		0
			@@4:			ret		_arglen
	ScanBits				ENDP

END
