;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - chkfilename.asm										*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;INT32 __stdcall CheckFileName(LPSTR lpPath)
	CheckFileName		PROC	USES ebx esi, PathPtr:DWORD
	LOCAL NameLen	: DWORD
	LOCAL Result	: DWORD
	LOCAL Last[4]	: BYTE
						mov		Result, CPR_VALID
						mov		esi, PathPtr
						invoke	StrLen, esi
						test	eax, eax
						jz		@@11
						mov		ecx, eax
						cmp		ecx, MAX_PATH - 4			; len("C:\") = 3 + terminating 0 = 4
						ja		@@10
						mov		NameLen,ecx
						xor		ebx,ebx						; last dot position
						xor		ah, ah						; the first char
			@@01:		mov		al, [esi]
						mov		Last, ah
						call	IsValidChar
						test	al, al
						jnz		@@04
						cmp		ah, '*'
						jne		@@02
						cmp		Last, "?"
						je		@@10
						jmp		@@03
			@@02:		cmp		ah, '?'
						jne		@@10
			@@03:		cmp		Last, "*"
						je		@@10
						mov		Result, CPR_WILDCARD
						jmp		@@05
			@@04:		test	dh, dh
						jz		@@05
						mov		ebx, esi					; it is a dot
			@@05:		inc		esi
						loop	@@01
						test	dx, dx
						jnz		@@10						; trailing space or dot: invalid
						mov		esi, PathPtr
						mov		ecx, NameLen
						test	ebx, ebx					; no extension
						jz		@@06
						mov		ecx, ebx
						sub		ecx, esi
			@@06:		cmp		ecx, 3
						jb		@@09
						cmp		ecx, 4
						ja		@@09
						mov     eax, [esi]
						and		eax, 000DFDFDFh				; Special uppercase
						cmp     cl, 4
						je		@@08
						mov		cl, ReservedNames
						lea		esi, Dev_Reserved
			@@07:		cmp		eax, [esi]
						je		@@10
						add		esi,4
						loop	@@07
						jmp		@@09
			@@08:		mov		dl, [esi + 3]				; test for LPTx and COMx
						sub		dl, "0"
						jbe		@@09
						cmp		dl,9
						ja		@@09
						cmp		eax, dword ptr Dev_LPT
						je		@@10
						cmp		eax, dword ptr Dev_COM
						je		@@10
			@@09:		mov		eax, Result
						jmp		@@11
			@@10:		xor		eax,eax						; CPR_Invalid
			@@11:		ret
		Dev_LPT			db		"LPT", 0
		Dev_COM			db		"COM", 0
		ReservedNames	equ		4
		Dev_Reserved	db		"CON", 0, "PRN", 0, "AUX", 0, "NUL", 0
	CheckFileName		ENDP

END
