;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - chrvalid.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;In:   al: character
;In:   ah: == 0:first character --> if space then error
;Out:  al: 0 if invalid character
;Out:  ah: character
;Out:  dl: 0 it is not space
;Out:  dh: 0 it is not dot
	IsValidChar			PROC	PUBLIC
						xor		dx, dx
						cmp		al, ' '
						jb		@@2			; error: < " "
						jne		@@1
						dec		dl			; mark: it is " ". can check for trailing space
						test	ah, ah
						jz		@@2			; error: leading space
						mov		ah, al
						jmp		@@3
			@@1:		cmp		al, '"'
						je		@@2
						cmp		al, '*'
						je		@@2
						cmp		al, '/'
						je		@@2
						cmp		al, ':'
						je		@@2
						cmp		al, '<'
						je		@@2
						cmp		al, '>'
						je		@@2
						cmp		al, '?'
						je		@@2
						cmp		al, '\'
						je		@@2
						cmp		al, '|'
						je		@@2
						mov		ah, al
						cmp		al, '.'
						jne		@@3
						dec		dh			; mark: it is ".". can check for trailing dot
						jmp		@@3
			@@2:		mov		ah, al
						xor		al, al
			@@3:		ret
	IsValidChar			ENDP

END
