;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - dateutils.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

.CONST

	g_DayTable			db		31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31

.CODE
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE


;*********************************************************************
;INT32 __stdcall asmYearToDay;
; In:	eax
; Out:	eax
	asmYearToDay		PROC	PUBLIC
						test	eax, eax
						jz		@@1
						push	ebx
						push	ecx
						push	edx
						imul	ecx, eax, 365
						inc		ecx
						dec		eax
						shr		eax, 2
						add		ecx, eax
						mov		ebx, 25
						xor		edx, edx
						div		ebx
						sub		ecx, eax
						shr		eax, 2
						add		eax, ecx
						pop		edx
						pop		ecx
						pop		ebx
			@@1:		ret
	asmYearToDay		ENDP
;*********************************************************************
; In:	eax
; Out:	eax
;INT32 __stdcall asmLeapYear;
	asmLeapYear			PROC	PUBLIC
						push	ecx
						push	edx
						xor		edx, edx
						mov		ecx, 4
						div		ecx
						test	edx, edx
						jnz		@@1
						mov		cl, 25
						div		ecx
						test	edx, edx
						mov		edx, 0
						jnz		@@1
						mov		cl, 4
						div		ecx
			@@1:		xor		eax, eax
						test	edx,edx
						setz	al
						pop		edx
						pop		ecx
						ret
	asmLeapYear			ENDP
;*********************************************************************
; In:	eax, ebx
;INT32 __stdcall asmDayToDate;
	asmDayToDate		PROC	PUBLIC
		ASSUME  ebx: ptr SYSTEMTIME
						push	ecx
						push	edx
						push	esi
						push	edi
						mov		edi, eax
						add		eax, 6
						xor		edx, edx
						mov		ecx, 7
						div		ecx
						mov		[ebx].wDayOfWeek, dx
						mov		eax, edi
						xor		edx, edx
						mov		ecx, 146097
						div		ecx
						imul	esi, eax, 400
						mov		ecx, 365
						mov		eax, edx
						mov		edi, edx						; edi = Days < 400 years
						xor		edx, edx
						div		ecx
						mov		edx, eax						; edx = plus years
						invoke	asmYearToDay
						cmp		eax, edi
						jbe		@@1
						dec		edx
						mov		eax, edx
						invoke	asmYearToDay
			@@1:		sub		edi, eax
						add		esi, edx
						mov		eax, esi
						mov		[ebx].wYear, ax
						invoke	asmLeapYear
						mov		edx, eax
						xor		ecx, ecx
						xor		eax, eax
			@@2:		mov		al, g_DayTable[ecx]
						cmp		cl, 1
						jne		@@3
						add		eax, edx
			@@3:		cmp		edi, eax
						jb		@@4
						sub		edi, eax
						inc		cl
						cmp		cl, 11
						jb		@@2
			@@4:		inc		cl
						mov		[ebx].wMonth, cx
						mov		eax, edi
						inc		eax
						mov		[ebx].wDay, ax
						pop		edi
						pop		esi
						pop		edx
						pop		ecx
						ret
	asmDayToDate		ENDP
;*********************************************************************
; In:	ebx
; Out:	eax
;INT32 __stdcall asmDateToDay;
	asmDateToDay		PROC	PUBLIC
						push	ecx
						push	edx
						push	esi
						movzx	eax, [ebx].SYSTEMTIME.wYear
						movzx	ecx, [ebx].SYSTEMTIME.wMonth
						mov		edx, eax
						invoke	asmYearToDay
						xchg	eax, edx
						cmp		ecx, 2
						jbe		@@1
						invoke	asmLeapYear
						add		edx, eax
			@@1:		xor		esi, esi
						xor		eax, eax
						dec		ecx
						jz		@@3
			@@2:		mov		al, g_DayTable[esi]
						add		edx, eax
						inc		esi
						loop	@@2
			@@3:		movzx	eax, [ebx].SYSTEMTIME.wDay
						add		eax, edx
						pop		esi
						pop		edx
						pop		ecx
						ret
	asmDateToDay		ENDP
;*********************************************************************
; In:	eax, edx, ebx
; Out:	edx destroyed
;INT32 __stdcall asmSecToTime;
	asmSecToTime		PROC
						push	ecx
						cmp		eax, 86400
						jb		@@1
						xor		eax,eax
						mov		dx, ax		
			@@1:		mov		[ebx].SYSTEMTIME.wMilliseconds, dx
						xor		edx, edx
						mov		ecx, 60
						div		ecx
						mov		[ebx].SYSTEMTIME.wSecond, dx
						xor		edx, edx
						div		ecx
						mov		[ebx].SYSTEMTIME.wMinute, dx
						mov		[ebx].SYSTEMTIME.wHour, ax
						pop		ecx
						ret
	asmSecToTime		ENDP
;*********************************************************************
; In:	ebx
; Out:	eax
;		ecx, edx destroyed
;INT32 __stdcall asmTimeToSec;
	asmTimeToSec		PROC	PUBLIC
						movzx	eax, [ebx].SYSTEMTIME.wHour
						mov		ecx, 60
						mul		ecx
						movzx	edx, [ebx].SYSTEMTIME.wMinute
						add		eax, edx
						mul		ecx
						movzx	edx, [ebx].SYSTEMTIME.wSecond
						add		eax, edx
						ret
	asmTimeToSec		ENDP

END
