;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - md5.asm												*
;********************************************************************
.586
.mmx
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

extern c	_mmxused : dword

.CODE

;*********************************************************************
;void __stdcall MD5_Calc(LPMD5INFOTABLE lpMD5Table, void *lpBuffer, INT32 ByteCnt);
	MD5_Calc			PROC USES ebx esi edi, TablePtr:DWORD, BufPtr:DWORD, ByteCnt:DWORD

						xor		eax, eax
						mov		ebx, TablePtr				;-->Flags
						mov		esi, BufPtr
						mov		edx, ByteCnt
						shl		edx, 3
						jz		@@5
						add		[ebx].MD5INFOTABLE.dwTotalLo, edx
						adc		[ebx].MD5INFOTABLE.dwTotalHi, eax
						shr     edx, 3
						mov		eax, [ebx].MD5INFOTABLE.dwInpBytes
						and		eax, eax
						jz		@@3
						lea		edi, [ebx].MD5INFOTABLE.cInpBuffer
						add		edi, eax									; edi -> cInpBuffer[dwInpBytes]
						mov		ecx, 64
						sub		ecx, eax									; ecx = 64 - dwInpBytes (free)
						cmp		edx, ecx
						jae		@@1
						mov		ecx, edx									
			@@1:		add		eax, ecx									; ecx = max(64 - dwInpBytes, ByteCnt)
						sub		edx, ecx
						rep		movsb
						cmp		al, 64
						jb		@@2
						push	edx
						push	esi
						lea		esi, [ebx].MD5INFOTABLE.cInpBuffer
						mov		edi, eax
						call	__CalcMMX
						pop		esi
						pop		edx
						xor		eax,eax
			@@2:		mov		[ebx].MD5INFOTABLE.dwInpBytes, eax
			@@3:		test	edx, edx
						jz		@@5
						mov		edi, edx
						and		edi, 0FFFFFFC0h
						sub		edx, edi
						push	edx
						test	edi, edi
						jz		@@4
						call	__CalcMMX
			@@4:		pop		ecx
						mov		[ebx].MD5INFOTABLE.dwInpBytes, ecx
						lea		edi, [ebx].MD5INFOTABLE.cInpBuffer
						rep		movsb
			@@5:		ret
	MD5_Calc			ENDP
;*********************************************************************
;void __stdcall MD5_Done(LPMD5INFOTABLE lpMD5Table, LPVOID lpCRC, BOOL bHex);
	MD5_Done			PROC	USES ebx esi edi, TablePtr: dword, lpCRC: dword, bHex: dword

						mov		ebx, TablePtr				;-->Flags
						lea		edi, [ebx].MD5INFOTABLE.cInpBuffer
						mov		eax, [ebx].MD5INFOTABLE.dwInpBytes
						add		edi, eax
						mov		ecx, 64
						mov		edx, ecx
						sub		cl, al
						sub		cl, 9
						jae		@@1
						add		cl, dl
						add		dl, dl
			@@1:		mov		al, 080h
						stosb
						xor		al,al
						rep		stosb
						lea		esi,[ebx].MD5INFOTABLE.dwTotalLo
						movsd
						movsd
						mov		edi, edx
						lea		esi,[ebx].MD5INFOTABLE.cInpBuffer
						call	__CalcMMX
						lea		esi, [ebx].MD5INFOTABLE.dwCRC
						mov		edi, lpCRC
						test	edi, edi
						jz		@@5
						mov		ecx, 16
						cmp		bHex, 0
						jne		@@2
						rep		movsb
						jmp		@@5
			@@2:		lodsb
						shl		ax, 4
						and		ah, 00Fh
						shr		al, 4
						mov		ch, 2
			@@3:		xchg	al, ah
						cmp		al, 10
						jb		@@4
						add		al, 027h
			@@4:		add		al, '0'
						stosb
						dec		ch
						jnz		@@3
						loop	@@2
						xor		eax, eax
						stosb
			@@5:		ret
	MD5_Done			ENDP

OPTION PROLOGUE: NONE
OPTION EPILOGUE: NONE
;*********************************************************************
; ebx --> MD5INFOTABLE
; esi --> BufPtr
; edi = ByteCnt
	__CalcMMX			PROC	PRIVATE

						xor		edx, edx
						pxor	mm0, mm0
						pxor    mm1, mm1
						pxor    mm2, mm2
						pxor    mm3, mm3
						movq    mm4, qword ptr [ebx].MD5INFOTABLE.dwCRC
						movq    mm5, qword ptr [ebx + 8].MD5INFOTABLE.dwCRC
						pcmpeqd	mm7, mm7
						psrlq	mm7, 32							;for mask and for not (with xor)
						jmp		@@07
			@@01:		xor		edx,edx
			@@02:		cmp		dl, 16
						jae		@@03
						movq	mm6, mm3
						pxor	mm6, mm2
						pand	mm6, mm1
						pxor	mm6, mm3
						jmp		@@06
			@@03:		cmp		dl, 32
						jae		@@04
						movq	mm6, mm2
						pxor	mm6, mm1
						pand	mm6, mm3
						pxor	mm6, mm2
						jmp		@@06
			@@04:		cmp		dl,48
						jae		@@05
						movq	mm6, mm1
						pxor	mm6, mm2
						pxor	mm6, mm3
						jmp		@@06
			@@05:		movq	mm6, mm3
						pxor	mm6, mm7
						por		mm6, mm1
						pxor	mm6, mm2
			@@06:		paddd	mm6, mm0
						movd	eax, mm6
						add		eax, [ebx + edx * 4].MD5INFOTABLE.dwPolynom
						mov		cx, [ebx + edx * 2].MD5INFOTABLE.wRotate
						xchg	ch, dl
						add		eax,[esi + edx*4]
						mov		dl,ch
						rol		eax, cl
						movq	mm0, mm3
						movq	mm3, mm2
						movq	mm2, mm1
						movd	mm6, eax
						paddd	mm1, mm6
						add		dl, 1
						cmp		dl, 64
						jb		@@02
			@@07:		paddd	mm4, mm0
						movq	mm0, mm4
						pand	mm0, mm7
						psllq	mm1, 32
						paddd	mm4, mm1
						movq	mm1, mm4
						psrlq	mm1, 32
						paddd	mm5, mm2
						movq	mm2, mm5
						pand	mm2, mm7
						psllq	mm3, 32
						paddd	mm5, mm3
						movq	mm3, mm5
						psrlq	mm3, 32
						add		esi, edx
						sub		edi, edx
						jnz		@@01
						movq	qword ptr [ebx].MD5INFOTABLE.dwCRC, mm4
						movq	qword ptr [ebx + 8].MD5INFOTABLE.dwCRC, mm5
						emms
						ret
	__CalcMMX			ENDP

END