;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - md5_any.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

.CODE

;*********************************************************************
;void __stdcall MD5_Calc_Any(LPMD5INFOTABLE lpMD5Table, void *lpBuffer, INT32 ByteCnt);
	MD5_Calc_Any		PROC USES ebx esi edi, TablePtr:DWORD, BufPtr:DWORD, ByteCnt:DWORD

						xor		eax, eax
						mov		ebx, TablePtr				;-->Flags
						mov		esi, BufPtr
						mov		edx, ByteCnt
						shl		edx, 3
						jz		@@5
						add		[ebx].MD5INFOTABLE.dwTotalLo, edx
						adc		[ebx].MD5INFOTABLE.dwTotalHi, eax
						shr     edx, 3
						mov		eax, [ebx].MD5INFOTABLE.dwInpBytes
						test	eax, eax
						jz		@@3
						lea		edi, [ebx].MD5INFOTABLE.cInpBuffer
						add		edi, eax
						mov		ecx, 64
						sub		ecx, eax
						cmp		edx, ecx
						jae		@@1
						mov		ecx, edx
			@@1:		add		eax, ecx
						sub		edx, ecx
						rep		movsb
						cmp		al, 64
						jb		@@2
						push	edx
						push	esi
						lea		esi, [ebx].MD5INFOTABLE.cInpBuffer
						mov		edi, eax
						call	__CalcStd
						pop		esi
						pop		edx
						xor		eax,eax
			@@2:		mov		[ebx].MD5INFOTABLE.dwInpBytes, eax
			@@3:		test	edx, edx
						jz		@@5
						mov		edi, edx
						and		edi, 0FFFFFFC0h
						sub		edx, edi
						push	edx
						test	edi, edi
						jz		@@4
						call	__CalcStd
			@@4:		pop		ecx
						mov		[ebx].MD5INFOTABLE.dwInpBytes, ecx
						lea		edi, [ebx].MD5INFOTABLE.cInpBuffer
						rep		movsb
			@@5:		ret
	MD5_Calc_Any		ENDP
;*********************************************************************
;void __stdcall MD5_Done(LPMD5INFOTABLE lpMD5Table, LPVOID lpCRC, BOOL bHex);
	MD5_Done_Any		PROC	USES ebx esi edi, TablePtr: dword, lpCRC: dword, bHex: dword

						mov		ebx, TablePtr				;-->Flags
						lea		edi, [ebx].MD5INFOTABLE.cInpBuffer
						mov		eax, [ebx].MD5INFOTABLE.dwInpBytes
						add		edi, eax
						mov		ecx, 64
						mov		edx, ecx
						sub		cl, al
						sub		cl, 9
						jae		@@1
						add		cl, dl
						add		dl, dl
			@@1:		mov		al, 080h
						stosb
						xor		al,al
						rep		stosb
						lea		esi,[ebx].MD5INFOTABLE.dwTotalLo
						movsd
						movsd
						mov		edi, edx
						lea		esi,[ebx].MD5INFOTABLE.cInpBuffer
						call	__CalcStd
						lea		esi, [ebx].MD5INFOTABLE.dwCRC
						mov		edi, lpCRC
						test	edi, edi
						jz		@@5
						mov		ecx, 16
						cmp		bHex, 0
						jne		@@2
						rep		movsb
						jmp		@@5
			@@2:		lodsb
						shl		ax, 4
						and		ah, 00Fh
						shr		al, 4
						mov		ch, 2
			@@3:		xchg	al, ah
						cmp		al, 10
						jb		@@4
						add		al, 027h
			@@4:		add		al, '0'
						stosb
						dec		ch
						jnz		@@3
						loop	@@2
						xor		eax, eax
						stosb
			@@5:		ret
	MD5_Done_Any		ENDP
;*********************************************************************
OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
	__CalcStd			PROC PRIVATE
	LOCAL CRC3: DWORD
	LOCAL CRC2: DWORD
	LOCAL CRC1: DWORD
	LOCAL CRC0: DWORD

						xor		edx, edx
						mov		CRC0, edx
						mov		CRC1, edx
						mov		CRC2, edx
						mov		CRC3, edx
						jmp		@@07
			@@01:		xor		edx, edx
			@@02:		cmp		dl, 16
						jae		@@03
						mov		eax, CRC1
						mov		ecx, eax
						and		ecx, CRC2
						not		eax
						and		eax, CRC3
						or		eax, ecx
						jmp		@@06
			@@03:		cmp		dl, 32
						jae		@@04
						mov		eax, CRC3
						mov		ecx, eax
						not		eax
						and		eax, CRC2
						and		ecx, CRC1
						or		eax, ecx
						jmp		@@06
			@@04:		cmp		dl, 48
						jae		@@05
						mov		eax, CRC1
						xor		eax, CRC2
						xor		eax, CRC3
						jmp		@@06
			@@05:		mov		eax, CRC3
						not		eax
						or		eax, CRC1
						xor		eax, CRC2
			@@06:		add		eax, CRC0
						add		eax, [ebx + edx * 4].MD5INFOTABLE.dwPolynom
						mov		cx, [ebx + edx * 2].MD5INFOTABLE.wRotate
						xchg	ch, dl
						add		eax, [esi + edx*4]
						mov		dl, ch
						rol		eax, cl
						xchg	eax, CRC1
						add		CRC1, eax
						xchg	eax, CRC2
						xchg	eax, CRC3
						mov		CRC0, eax
						add		dl, 1
						cmp		dl, 64
						jb		@@02
			@@07:		mov		eax, CRC0
						add		eax, [ebx + 0].MD5INFOTABLE.dwCRC
						mov		[ebx  + 0].MD5INFOTABLE.dwCRC,eax
						mov		CRC0, eax
						mov		eax, CRC1
						add		eax, [ebx + 4].MD5INFOTABLE.dwCRC
						mov		[ebx + 4].MD5INFOTABLE.dwCRC, eax
						mov		CRC1, eax
						mov		eax, CRC2
						add		eax, [ebx + 8].MD5INFOTABLE.dwCRC
						mov		[ebx + 8].MD5INFOTABLE.dwCRC, eax
						mov		CRC2, eax
						mov		eax, CRC3
						add		eax, [ebx + 12].MD5INFOTABLE.dwCRC
						mov		[ebx + 12].MD5INFOTABLE.dwCRC, eax
						mov		CRC3, eax
						add		esi, edx
						sub		edi, edx
						jnz		@@01
						ret
	__CalcStd			ENDP


END