;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - md5_init.asm											*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

.CONST

	m_n65536			dd		65536
	m_RotateTable		db		7,12,17,22,5,9,14,20,4,11,16,23,6,10,15,21
	m_InitCRC			dd		067452301h,0EFCDAB89h,098BADCFEh,010325476h

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;void __stdcall MD5_Init(LPMD5INFOTABLE lpMD5Table);
	MD5_Init			PROC	USES ebx esi edi, TablePtr:DWORD
	LOCAL TempDW	: DWORD
	LOCAL TempQW	: QWORD

						mov		ebx, TablePtr
						xor		eax, eax
						lea		edi, [ebx].MD5INFOTABLE.dwFlags
						mov		ecx, (MD5INFOTABLE.dwCRC - MD5INFOTABLE.dwFlags) shr 2
						rep		stosd							; dwFlags = dwBuffer = dwBufSize = dwInpBytes = dwTotalLo = dwTotalHi = 0
						lea		esi, m_InitCRC
						mov		cl, (SIZEOF MD5INFOTABLE.dwCRC) shr 2
						rep		movsd
						mov		esi, ebx
						fldcw	g_nTruncFpuCW
						fild	m_n65536
						fmul	st, st
						xor		ebx, ebx
			@@1:		lea		eax, [ebx + 1]
						mov		TempDW, eax
						fild	TempDW
						fsin
						fabs
						fmul	st, st(1)
						frndint
						fistp	TempQW
						fwait
						mov		eax,dword ptr TempQW
						mov     [esi + 4 * ebx].MD5INFOTABLE.dwPolynom, eax
						mov		eax, ebx
						shr		eax, 4
						mov		edx, eax
						jnz		@@2
						mov		ecx, ebx
						jmp		@@5
			@@2:		dec		eax
						jnz		@@3
						imul	ecx, ebx, 5
						inc		cx
						jmp		@@5
			@@3:		dec		eax
						jnz		@@4
						imul	ecx, ebx, 3
						add		cx, 5
						jmp		@@5
			@@4:		imul	ecx, ebx, 7
			@@5:		and		cl, 00Fh
						mov		ch, cl
						shl		dl, 2
						mov		al, bl
						and		al, 3
						or		dl, al
						mov		cl, m_RotateTable[edx]
						mov		[esi + 2 * ebx].MD5INFOTABLE.wRotate, cx
						inc		ebx
						cmp		bl, 64
						jb		@@1
						fistp	TempDW
						fldcw   g_nDefaultFpuCW
						xor     eax, eax
						ret
	MD5_Init			ENDP

END