;********************************************************************
;* Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
;*																	*
;* skclib32 - performance.asm										*
;********************************************************************
.586
.MODEL FLAT, STDCALL
option casemap :none
option scoped

.NOLIST

include skclib32.inc

.LIST

extern c	_fltused : dword

.CODE

OPTION PROLOGUE: PrologueDef 
OPTION EPILOGUE: EpilogueDef 
;*********************************************************************
;In: esi --> QWORD
	Performance			PROC	PRIVATE
	LOCAL Value : LARGEINT
						lea		eax, Value
						invoke	QueryPerformanceCounter, eax
						test	eax, eax
						jz		@@1
						mov     ecx, Value.u32lo
						mov     edx, Value.u32hi
						jmp		@@2
			@@1:		invoke	GetTickCount
						cdq
						mov		ecx, eax
						xor     eax, eax
			@@2:		mov		[esi], ecx
						mov		[esi + 4],edx
						ret
	Performance			ENDP
;*********************************************************************
	PerformanceStart	PROC	USES ESI, StrtPtr : DWORD
						mov		esi, StrtPtr
						call	Performance
						ret
	PerformanceStart	ENDP
;*********************************************************************
;INT64 __stdcall PerformanceStop(LPINT64 lpStart, BOOL bMilliSec);
	PerformanceStop		PROC	USES ESI, StrtPtr : DWORD, bMilliSec : DWORD
	LOCAL StopVal : LARGEINT
	LOCAL FreqVal : LARGEINT
						lea		esi, StopVal
						call	Performance
						test	eax, eax
						jnz		@@1
						mov		FreqVal.u32hi, eax
						inc		eax
						mov		FreqVal.u32lo, eax
						fild	g_nThousand
						jmp		@@2
			@@1:		lea		eax, FreqVal
						invoke	QueryPerformanceFrequency, eax
						xor		edx, edx
						test	eax, eax
						jz		@@4
						fild	g_nMillion
			@@2:		mov		edx,StrtPtr
						mov		eax, [edx]
						sub		StopVal.u32lo, eax
						mov     eax, [edx + 4]
						sbb		StopVal.u32hi, eax
						fild    StopVal.u64
						fmulp	st(1), st
						fild	FreqVal.u64
						fdivp	st(1), st
						frndint
						mov		ecx, bMilliSec
						jecxz	@@3
						fidiv	g_nThousand
			@@3:		fistp   StopVal.u64
						fwait
						mov		eax, StopVal.u32lo
						mov		edx, StopVal.u32hi
						test	edx, edx
						jz		@@4
						jecxz	@@4
						xor		edx, edx
						lea		eax, [edx - 1]
			@@4:		ret
	PerformanceStop		ENDP

END