#pragma once
#ifndef _INC_PRIVATE
#define _INC_PRIVATE

#include <skclib32.h>

#if defined(__cplusplus) && !defined(_DEF_EXTERNC)
#define _DEF_EXTERNC
#define _DEF_PRIVATE_EXTERNC
extern "C" {
#endif

#define TXT_EXTRABUFSIZE	1024
#define MAX_LINESIZE		2048
#define MAX_SECTIONSIZE		128
#define MAX_KEYSIZE			128

#pragma pack(push, 1)

typedef struct tagINIBUFINFO {
	LPSTR		pBufEnd;
	LPSTR		pSect;
	LPSTR		pSectFirst;
	LPSTR		pSectEnd;
	LPSTR		pKeyFirst;
	LPSTR		pKeyLast;
	LPSTR		pCmntFirst;
	LPSTR		pCmntLast;
	LPSTR		pDst;
	INT32		nSectLen;
	INT32		nKeyLen;
	INT32		nValLen;
	INT32		nDelLen;
	INT32		nTxtLen;
	char		cSect[MAX_SECTIONSIZE];
	char		cKey[MAX_KEYSIZE];
	char		cVal[MAX_LINESIZE];
} INIBUFINFO, *LPINIBUFINFO;

#pragma pack(pop)

void __stdcall pScanIniBuf(LPSTR lpBuf, LPSTR lpSect, LPSTR lpKey, LPINIBUFINFO lpInfo);
void __stdcall pUpdateIniBuf(LPSTR *lpIniBuf, LPINIBUFINFO lpInfo);
INT32 __stdcall pChkIniFolder(LPSTR lpFolder, LPSTR lpDefault, INT32 nFlags);

#if defined(_PRIVATE_EXTERNC)
}
#undef _DEF_EXTERNC
#undef _DEF_UDPPRIVATE_EXTERNC
#endif

#endif  // _INC_PRIVATE
