/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - aboutbox.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
static INT32 CALLBACK AboutDlgProc(HWND hDlg, UINT32 uMsg, WPARAM wParam, LPARAM lParam) {
LPDRAWITEMSTRUCT	pDIS;
INT32				nRet, nID;

	switch (uMsg) {
	case WM_INITDIALOG:
		CenterWindow(hDlg, GetParent(hDlg));
		SetCursorFromResource(hDlg, NULL, IDC_ARROW);
		return TRUE;
	case WM_CTLCOLORSTATIC:
		nID = GetDlgCtrlID((HWND) lParam);
		if ((nID >= IDC_TRANSTXTFIRST) && (nID <= IDC_TRANSTXTLAST)) {
			SetBkMode((HDC) wParam, TRANSPARENT);
			return (LRESULT) GetStockObject(NULL_BRUSH);
		}
		break;
	case WM_DRAWITEM:
		pDIS = (LPDRAWITEMSTRUCT) lParam;
		if (wParam == IDC_SEPARATOR) {
			DrawEdge(pDIS->hDC, &pDIS->rcItem, EDGE_ETCHED, BF_TOP);
			return TRUE;
		}
		break;
	case WM_COMMAND:
		nRet = 0;
		switch (LOWORD(wParam)) {
		case IDOK:
			nRet = IDOK;
		case IDCANCEL:
			EndDialog (hDlg, nRet);
			return TRUE ;
		}
		break;
	}
	return FALSE;
}
// **********************************************************************************
INT32 __stdcall AboutBox(HWND hOwner, INT32 nDlgID) {
INT32		nRet;

	nRet = DialogBox(g_hResource, RESSTR(nDlgID), hOwner, AboutDlgProc);
	return nRet;
}
