/********************************************************************
 * Copyright (c) 2011-19 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - chainhandler.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

// **********************************************************************************
LPVOID __stdcall Chain_AddItem(LPVOID lpItem, LPVOID lpStart) {
LPCHAIN		pAct;

	pAct = lpItem;
	pAct->pNext = lpStart;
	return lpItem;
}
// **********************************************************************************
LPVOID __stdcall Chain_DelItem(UINT32 nID, LPVOID lpStart) {
LPCHAIN		pAct, pNext, pRet;

	if (!lpStart) return NULL;
	pRet = lpStart;
	if (pRet->nID == nID) {
		pRet = pRet->pNext;
	}
	else {
		pAct = pRet;
		pNext = pAct->pNext;
		while (pNext) {
			if (pNext->nID == nID) {
				pAct->pNext = pNext->pNext;
				pNext = NULL;
			}
			else {
				pAct = pNext;
				pNext = pAct->pNext;
			}
		}
	}
	return pRet;
}
// **********************************************************************************
LPVOID __stdcall Chain_GetItem(UINT32 nID, LPVOID lpStart) {
LPCHAIN		pAct, pRet;

	pRet = NULL;
	pAct = lpStart;
	while (pAct) {
		if (pAct->nID == nID) {
			pRet = pAct;
			pAct = NULL;
		}
		else {
			pAct = pAct->pNext;
		}
	}
	return pRet;
}
// **********************************************************************************
UINT32 __stdcall Chain_GetID(LPVOID lpChain) {
LPCHAIN		pAct;
UINT32		nRet;

	pAct = lpChain;
	nRet = pAct ? pAct->nID : 0;
	return nRet;
}
// **********************************************************************************
LPVOID __stdcall Chain_GetNext(LPVOID lpChain) {
LPCHAIN		pAct, pRet;

	pAct = lpChain;
	pRet = pAct ? pAct->pNext : NULL;
	return pRet;
}
