/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - chkinifolder.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "private.h"
// **********************************************************************************
INT32 __stdcall pChkIniFolder(LPSTR lpFolder, LPSTR lpDefault, INT32 nFlags) {
WIN32_FILE_ATTRIBUTE_DATA	fd;
INT32						cpr, nRet;
BOOL						bOK;

	bOK = FALSE;
	if (nRet = StrLen(lpFolder)) {
		cpr = CheckFolderName(lpFolder);
		if (cpr >= CPR_VALID) {
			bOK = TRUE;
			if (nFlags & IFF_EXISTS) {
				FormatFolder(lpFolder, cpr == CPR_ROOT);
				bOK = GetFileAttributesEx(lpFolder, GetFileExInfoStandard, &fd);
				if (bOK && (((fd.dwFileAttributes & FA_DIRECTORY) == 0) || (fd.dwFileAttributes & FA_UNKNOWN))) bOK = FALSE;
			}
		}
	}
	if (!bOK) nRet = StrCpy(lpFolder, lpDefault);
	if (nRet) {
		bOK = (nFlags & IFF_CREATE) ? CreateFolder(lpFolder, NULL) : TRUE;
		if ((nFlags & IFF_ONERRDEF) && !bOK) bOK = nRet = StrCpy(lpFolder, lpDefault);
	}
	else bOK = FALSE;
	if (bOK) nRet = FormatFolder(lpFolder, nFlags & IFF_ADDBSLASH);
	else {
		nRet = 0;
		lpFolder[0] = 0;
	}
	return nRet;
}