/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - createfolder.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
BOOL __stdcall CreateFolder(LPSTR lpFolder, LPINT lpError) {
INT32		nPos, nLen, nErr, nCPR;
char		cRoot[MAX_PATH], cFolder[MAX_PATH];
BOOL		bRet;

	StrCpy(cFolder, lpFolder);
	nLen = FormatFolder(cFolder, TRUE);
	nCPR = CheckFolderName(cFolder);
	bRet = FALSE;
	if (nCPR >= CPR_VALID) {
		nPos = GetRootDir(cRoot, cFolder);
		nErr = 0;
		if (nLen != nPos) {
			cFolder[--nLen] = '\0';
			if (FolderExists(cFolder)) bRet = TRUE;
			else {
				cFolder[nLen++] = '\\';
				while ((nPos > 0) && (nPos < nLen) && !nErr) {
					nPos = ChrInStr(cFolder, '\\', nPos, nLen, FALSE);
					if (nPos > 0) {
						cFolder[nPos] = '\0';
						if (!FolderExists(cFolder)) {
							if (!CreateDirectory(cFolder, NULL)) nErr = GetLastError();
						}
						cFolder[nPos++] = '\\';
					}
				}
				if (!nErr) bRet = TRUE;
			}
		}
		else bRet = FolderExists(cFolder);
	}
	else nErr = ERROR_PATH_NOT_FOUND;
	if (nErr) SetErrorFlags(ERRF_FILE | nErr);
	if (lpError) *lpError = nErr;
	return bRet;
}

