/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - createlogfont.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
HFONT __stdcall CreateLogFont(HWND hWnd, INT32 nHeight, INT32 nWeight, INT32 nChrSet, LPSTR lpFontName) {
LOGFONT		lf;
HDC			hDC;
INT32		nFact;

	MemClr(&lf, sizeof(lf));
	if (hWnd) {
		hDC = GetDC(hWnd);
		nFact = GetDeviceCaps(hDC, LOGPIXELSY);
		ReleaseDC(hWnd, hDC);
	}
	else nFact = 72;
	lf.lfHeight = nHeight * nFact / 72;
	lf.lfWeight = nWeight;
	lf.lfCharSet = nChrSet;
	StrCpy(lf.lfFaceName, lpFontName);
	return CreateFontIndirect(&lf);
}
