/********************************************************************
 * Copyright (c) 2011-18 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - daylight.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
BOOL						g_bDayLightStart			= FALSE;
BOOL						g_bDayLightEnd				= FALSE;
BOOL						g_bDayLightActive			= FALSE;
// **********************************************************************************
void __stdcall DayLightInit(LPSYSTEMTIME lpSt) {
BOOL	bStart, bEnd;

	bStart = lpSt->wMonth == 3;
	bEnd = lpSt->wMonth == 10;
	if ((lpSt->wDay <= 24) || lpSt->wDayOfWeek) {
		bStart = bEnd = FALSE;
	}
	g_bDayLightStart = bStart;
	g_bDayLightEnd = bEnd;
}
// **********************************************************************************
INT32 __stdcall GetSecOfDay(INT32 nCurSec, LPSYSTEMTIME lpSt) {
INT32	nSec;

	nSec = TimeToSec(lpSt);
	if (g_bDayLightEnd && g_bDayLightActive && (lpSt->wHour == 2) && (nSec < nCurSec)) g_bDayLightActive = FALSE;
	if (g_bDayLightStart && !g_bDayLightActive && (lpSt->wHour >= 2)) g_bDayLightActive = TRUE;
	if (g_bDayLightEnd && !g_bDayLightActive) nSec += 3600;
	return nSec;
}
// **********************************************************************************
BOOL __stdcall DayLightSec(INT32 nStartYear, UINT32 nSec) {
SYSTEMTIME	st;
UINT32		nDay, nStart, nEnd;

	nDay = nSec / SECONDSOFDAY;
	DayToDate(nDay, nStartYear, &st);
	nStart = GetDayOfWeek(st.wYear, 3, 31);
	st.wDay = 31 - nStart;
	st.wMonth = 3;
	nStart = DateToDay(nStartYear, &st) * SECONDSOFDAY + 7200;
	nEnd = GetDayOfWeek(st.wYear, 10, 31);
	st.wDay = 31 - nEnd;
	st.wMonth = 10;
	nEnd = DateToDay(nStartYear, &st) * SECONDSOFDAY + 7200;
	return (nSec > nStart) && (nSec < nEnd);
}
