/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - doevents.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
BOOL __stdcall DoEvents(LPVOID lpAnyInt, UINT32 nTimeOut, TESTEVENTPROC TestEvent) {
#define MAXMESSAGE		100
LPTIDDATA	pTid;
MSG			Msg;
BOOL		bProcess, bBreak, bQuit, bMsg;
INT32		nCnt;
UINT32		nStart, nDelta;

	pTid = _getptd();
	if (nTimeOut) nStart = GetTickCount();
	nCnt = 0;
	pTid->bInDoEvents = TRUE;
	bBreak = bQuit = FALSE;
	do {
		if (bMsg = PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE)) {
			if (Msg.message == WM_QUIT) {
				PostQuitMessage(Msg.wParam);
				bBreak = bQuit = TRUE;
			}
			else {
				bProcess = (TestEvent) ? TestEvent(&Msg) : TRUE;
				if (bProcess) ProcessMessage(&Msg);
			}
			nCnt++;
		}
		if (!lpAnyInt && !nTimeOut) {
			if ((nCnt >= MAXMESSAGE) || !bMsg) bBreak = TRUE;
		}
		else {
			if (lpAnyInt && !(*(LPINT32) lpAnyInt)) bBreak = TRUE;
			if (nTimeOut) {
				nDelta = GetTickCount() - nStart;
				if (nDelta >= nTimeOut) bBreak = TRUE;
			}
		}
		if (!bBreak) Sleep(0);
	} while (!bBreak);
	pTid->bInDoEvents = FALSE;
	return bQuit;
}
