/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - duplicatebitmap.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
HBITMAP __stdcall DuplicateBitmap(HDC hDC, HBITMAP hSrcBmp, COLORREF crBkGr,
									INT32 nWidth, INT32 nHeight, INT32 nSrcX, INT32 nSrcY, BOOL bStretch) {
HBITMAP		hNewBmp, hSrcOld, hDstOld;
BITMAP		bm;
RECT		rFill;
HDC			hSrcDC, hDstDC;

	hSrcDC = CreateCompatibleDC(hDC);
	hDstDC = CreateCompatibleDC(hDC);
	GetObject(hSrcBmp, sizeof(bm), &bm);
	hNewBmp = CreateCompatibleBitmap(hDC, nWidth, nHeight) ;
	if (hNewBmp) {
		hSrcOld = SelectObject(hSrcDC, hSrcBmp);
		hDstOld = SelectObject(hDstDC, hNewBmp);
		if (bStretch) StretchBlt(hDstDC, 0, 0, nWidth, nHeight, hSrcDC, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY);
		else {
			if ((bm.bmWidth < nWidth) || (bm.bmHeight < nHeight)) {
				SetRect(&rFill, 0, 0, nWidth, nHeight) ;
				FillRectEx(hDstDC, &rFill, crBkGr);
			}
			BitBlt(hDstDC, 0, 0, nWidth, nHeight, hSrcDC, nSrcX, nSrcY, SRCCOPY);
		}
		SelectObject(hSrcDC, hSrcOld);
		SelectObject(hDstDC, hDstOld);
	}
	DeleteDC(hSrcDC);
	DeleteDC(hDstDC);
	return hNewBmp;
}
