/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - editwin.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skCLib32.h>

#define MAX_EDITLINE		800
// **********************************************************************************
LPEDITWIN __stdcall EditWin_Init(HWND hParent, HWND hEdit, INT32 nMaxLen, INT32 nMaxLine) {
LPTIDDATA	ptd;
LPEDITWIN	pWin;

	if ((!nMaxLen) && (!nMaxLine)) nMaxLine = MAX_EDITLINE;
	pWin = GetMem(GMM_CLEAR, sizeof(EDITWIN));
	if (pWin) {
		ptd = _getptd();
		pWin->hParent = hParent;
		pWin->hEdit = hEdit;
		pWin->hThread = ptd->hThread;
		if (nMaxLen) {
			pWin->nMaxLen = nMaxLen;
			pWin->nChkLen = nMaxLen >> 2;
			SendMessage(hEdit, EM_LIMITTEXT, nMaxLen, 0);
		}
		if (nMaxLine) {
			pWin->nMaxLine = nMaxLine;
			pWin->nChkLine = nMaxLine >> 2;
		}
		SendMessage(hEdit, WM_SETTEXT, 0, (LPARAM) NULL);
	}
	return pWin;
}
// **********************************************************************************
void __stdcall EditWin_Clear(LPEDITWIN lpEdit) {
INT32	i;

	for (i = 0; i < 3; i++) {
		lpEdit->nLineTbl[i] = lpEdit->nSizeTbl[i] = 0;
	}
	lpEdit->nActLen = lpEdit->nActLine = lpEdit->nIdx = 0;
	if (lpEdit->nMaxLen) lpEdit->nChkLen = lpEdit->nMaxLen >> 2;
	if (lpEdit->nMaxLine) lpEdit->nChkLine = lpEdit->nMaxLine >> 2;
	SendMessage(lpEdit->hEdit, WM_SETTEXT, 0, (LPARAM) NULL);
}
// **********************************************************************************
void __stdcall EditWin_Write(LPEDITWIN lpEdit, LPSTR lpStr, INT32 nStrLen, BOOL bLocal) {
LPTIDDATA	ptd;
BOOL		bOwnThread;

	if (lpEdit) {
		ptd = _getptd();
		if (lpEdit->hThread == ptd->hThread) bOwnThread = TRUE;
		else {
			if (bLocal) lpStr = NewStr(lpStr, nStrLen);
			bOwnThread = FALSE;
		}
		if (bOwnThread) EditWin_Update(lpEdit, lpStr, !bLocal);
		else PostMessage(lpEdit->hParent, WM_SK_LOG, (WPARAM) lpStr, (LPARAM) lpEdit);
	}
	else if (!bLocal) FreeMem(lpStr);
}
// **********************************************************************************
void __stdcall EditWin_Update(LPEDITWIN lpEdit, LPSTR lpStr, BOOL bFreeStr) {
WINDOWPLACEMENT		wp;
INT32				nSelStart, nSelEnd, nLen;
INT32				i, nActLine, nActLen, nDelLine, nDelLen;
BOOL				bMax, bMinimized;

	nActLine = StrLines(lpStr, &nActLen);
	if (lpEdit && nActLen) {
		bMinimized = GetWindowPlacement(lpEdit->hParent, &wp) && (wp.showCmd == SW_SHOWMINIMIZED);
		nLen = lpEdit->nActLen;
		SendMessage(lpEdit->hEdit, EM_GETSEL, (WPARAM) &nSelStart, (LPARAM) &nSelEnd);
		bMax = FALSE;
		if (lpEdit->nMaxLen) {
			if ((lpEdit->nActLen + nActLen) > lpEdit->nChkLen) bMax = TRUE;
		}
		if (!bMax && lpEdit->nMaxLine) {
			if ((lpEdit->nActLine + nActLine) > lpEdit->nChkLine) bMax = TRUE;
		}
		nDelLen = 0;
		if (bMax) {
			if (lpEdit->nIdx < 3) {
				lpEdit->nSizeTbl[lpEdit->nIdx] = lpEdit->nActLen;
				lpEdit->nLineTbl[lpEdit->nIdx] = lpEdit->nActLine;
				lpEdit->nChkLen += lpEdit->nMaxLen >> 2;
				lpEdit->nChkLine += lpEdit->nMaxLine >> 2;
				lpEdit->nIdx++;
			}
			else {
				nDelLen = lpEdit->nSizeTbl[0];
				nDelLine = lpEdit->nLineTbl[0];
				SendMessage(lpEdit->hEdit, EM_SETSEL, 0, nDelLen);
				SendMessage(lpEdit->hEdit, EM_REPLACESEL, 0, (LPARAM) STR_EMPTY);
				if (!bMinimized) RedrawWindow(lpEdit->hEdit, NULL, NULL, RDW_INVALIDATE);
				for (i = 0; i < 2; i++) {
					lpEdit->nSizeTbl[i] = lpEdit->nSizeTbl[i + 1] - nDelLen;
					lpEdit->nLineTbl[i] = lpEdit->nLineTbl[i + 1] - nDelLine;
				}
				lpEdit->nActLen -= nDelLen;
				lpEdit->nActLine -= nDelLine;
				lpEdit->nSizeTbl[2] = lpEdit->nActLen;
				lpEdit->nLineTbl[2] = lpEdit->nActLine;
			}
		}
		SendMessage(lpEdit->hEdit, EM_SETSEL, lpEdit->nActLen, lpEdit->nActLen);
		SendMessage(lpEdit->hEdit, EM_REPLACESEL, 0, (LPARAM) lpStr);
		lpEdit->nActLen += nActLen;
		lpEdit->nActLine += nActLine;
		if ((nSelEnd == nSelStart) && (nSelEnd == nLen)) {
			nSelEnd = nSelStart = lpEdit->nActLen;
		}
		else {
			nSelEnd -= nDelLen;
			if (nSelEnd < 0) nSelEnd = 0;
			nSelStart -= nDelLen;
			if (nSelStart < 0) nSelStart = 0;
			if (!nSelStart && !nSelEnd) nSelEnd = nSelStart = lpEdit->nActLen;
		}
		SendMessage(lpEdit->hEdit, EM_SETSEL, nSelStart, nSelEnd);
		if (!bMinimized) SendMessage(lpEdit->hEdit, EM_SCROLLCARET, 0, 0);
	}
	if (bFreeStr) FreeMem(lpStr);
}
// **********************************************************************************
void __stdcall EditWin_Done(LPEDITWIN lpEdit) {

	FreeMem(lpEdit);
}
