/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fcopy.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall FCopy(LPSTR lpDstName, LPSTR lpSrcName, LPSYSTEMTIME lpTime, LPVOID lpInfo, PROGRESSPROC lpProgress, LPINT32 lpErr) {
#define MAX_BUFFERSIZE		32768
INT64			nFileSize, nCopiedSize;
INT32			nErr, nTmp, nSize;
LPFILEIO		pSrcFile, pDstFile;
LPVOID			lpBuf;
BOOL			bCancel;

	nFileSize = GetFSize(lpSrcName, &nErr);
	if (nFileSize) {
		bCancel = FALSE;
		lpBuf = GetMem(GMM_DEFAULT, MAX_BUFFERSIZE);
		pSrcFile = FOpen(lpSrcName, FOM_READ | FOM_SHARE, NULL);
		pDstFile = FOpen(lpDstName, FOM_REWRITE, NULL);
		if (pSrcFile && pDstFile) {
			nCopiedSize = 0;
			while ((nCopiedSize < nFileSize) && (!pSrcFile->nErr) && (!pDstFile->nErr) && !bCancel) {
				nSize = (INT32) min(MAX_BUFFERSIZE, nFileSize - nCopiedSize);
				nSize = FRead(pSrcFile, lpBuf, nSize);
				if (nSize) nSize = FWrite(pDstFile, lpBuf, nSize);
				nCopiedSize += nSize;
				if (lpProgress) bCancel = lpProgress(nFileSize, nCopiedSize, lpInfo);
			}
		}
		if (!pDstFile->nErr && lpTime) FSetTime(pDstFile, FT_CREATION | FT_LASTACCESS | FT_LASTWRITE, lpTime);
		nErr = FClose(pDstFile);
		nTmp = FClose(pSrcFile);
		if (!nErr) nErr = nTmp;
		FreeMem(lpBuf);
		if (bCancel) nErr = ERROR_CANCELLED;
		if (nErr) FDelete(lpDstName, TRUE);
	}
	if (nErr) SetErrorFlags(ERRF_FILE | nErr);
	if (lpErr) *lpErr = nErr;
	return nErr;
}
