/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fexpand.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

// **********************************************************************************
INT32 __stdcall FExpand(LPSTR lpDstName, LPSTR lpSrcName, LPSTR lpDefDir, BOOL bFromPC) {
INT32	k, n, nRet, nMin, nLen;
char	cSrch[6], cBuf[MAX_PATH], cSrc[MAX_PATH], cDefDir[MAX_PATH], cRoot[MAX_PATH];

	if (lpDefDir) {
		StrCpy(cDefDir, lpDefDir);
	}
	else {
		FSplit(TRUE, cDefDir, NULL, g_cProgName);
	}
	GetRootDir(cRoot, cDefDir);
	nLen = StrCpy(cSrc, lpSrcName);
	nRet = 0;
	if (lpDstName) {
		lpDstName[0] = '\0';
		if (!nLen) {
			nLen = StrCpy(cBuf, cDefDir);
		}
		else {
			if (cSrc[0] == '\\') {
				if (cSrc[1] == '\\') {
					nLen = StrCpy(cBuf, cSrc);
				}
				else {
					if (bFromPC) {
						nLen = ChrInStr(cRoot, '\\', 3, MAX_SIGNED32, FALSE);
						if (nLen > 0) cRoot[nLen + 1] = 0;
					}
					nLen = StrXCpy(cBuf, cRoot, &cSrc[1]);
				}
			}
			else {
				if (cSrc[1] == ':') {
					nLen = StrCpy(cBuf, cSrc);
				}
				else {
					nLen = StrXCpy(cBuf, cDefDir, cSrc);
				}
			}
		}
		nMin = ChrInStr(cBuf, '\\', 2, nLen, FALSE);
		if (nMin >= 2) {
			cSrch[0] = '\\';
			StrCpy(&cSrch[1], STR_DOTBSLASH);
			do {
				k = StrInStr(cBuf, cSrch, 0, FALSE);
				if (k >= nMin) {
					StrCpy(&cBuf[k + 1], &cBuf[k + 3]);
					nLen -= 2;
				}
			} while (k >= nMin);
			StrCpy(&cSrch[1], STR_DBLDOTBSLASH);
			do {
				k = StrInStr(cBuf, cSrch, 0, FALSE);
				if (k > nMin) {
					n = ChrInStrRev(cBuf, '\\', k - 1, FALSE);
					if (n < nMin) {
						k = nLen = 0;
					}
					else {
						StrCpy(&cBuf[n + 1], &cBuf[k + 4]);
					}
				}
				else {
					if (k >= 0) nLen = 0;
				}
			} while (k > nMin);
		}
		if (nLen) nRet = StrCpy(lpDstName, cBuf);
	}
	return nRet;

}
