/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fgettime.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

// **********************************************************************************
INT32 __stdcall FGetTime(LPFILEIO lpFile, INT32 nMode, LPSYSTEMTIME lpFileTime) {
FILETIME		LocFT, CreationTime, LastAccessTime, LastWriteTime;
LPFILETIME		pFT;
INT32			nErr;
BOOL			bOK;

	MemClr(lpFileTime, sizeof(SYSTEMTIME));
	if (!lpFile) return FALSE;
	bOK = GetFileTime(lpFile->hFile, &CreationTime, &LastAccessTime, &LastWriteTime);
	if (bOK) {
		if (nMode == FT_CREATION) pFT = &CreationTime;
		else if (nMode == FT_LASTACCESS) pFT = &LastAccessTime;
		else pFT = &LastWriteTime;
		FileTimeToLocalFileTime(pFT, &LocFT);
		FileTimeToSystemTime(&LocFT, lpFileTime);
		nErr = 0;
	}
	else { 
		nErr = GetLastError();;
		if (!lpFile->nErr) lpFile->nErr = nErr;
		SetErrorFlags(ERRF_FILE | nErr);
	}
	return nErr;
}
