/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fread.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
UINT32 __stdcall FRead(LPFILEIO lpFile, LPVOID lpBuffer, UINT32 nNumberOfBytesToRead) {
INT32	nErr;
UINT32	nRetVal;

	if (!lpFile) return 0;
	nRetVal = 0;
	if ((lpFile->hFile == INVALID_HANDLE_VALUE)) nErr = ERROR_INVALID_HANDLE;
	else {
		if (!ReadFile(lpFile->hFile, lpBuffer, nNumberOfBytesToRead, &nRetVal, NULL)) {
			nErr = GetLastError();
			nRetVal = 0;
		}
		else {
			nErr = (nRetVal == nNumberOfBytesToRead) ? NO_ERROR : ERROR_READ_FAULT;
		}
		lpFile->nPos += nRetVal;
		if (nRetVal && lpFile->pIOProc) lpFile->pIOProc(FCBM_READ, lpFile, lpBuffer, nRetVal);
	}
	if (nErr) {
		if (!lpFile->nErr) lpFile->nErr = nErr;
		SetErrorFlags(ERRF_FILE | nErr);
	}
	return nRetVal;
}
