/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fseek.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
UINT64 __stdcall FSeek(LPFILEIO lpFile, INT64 nMove, UINT32 nMode) {
INT32	nErr, nRetry;

	if (!lpFile) return 0;
	if (lpFile->hFile == INVALID_HANDLE_VALUE) nErr = ERROR_INVALID_HANDLE;
	else {
		nRetry = 2;
		do {
			lpFile->nPos = nMove;
			lpFile->nPosLo = SetFilePointer(lpFile->hFile, lpFile->nPosLo, &lpFile->nPosHi, nMode);
			nErr = (lpFile->nPosLo == INVALID_SET_FILE_POINTER) ? GetLastError() : NO_ERROR;
			if (!nErr && (lpFile->nPos > lpFile->nSize)) {
				nMove = lpFile->nSize;
				nMode = FSM_BEGIN;
				nRetry--;
			}
			else nRetry = 0;
		} while (nRetry);
	}
	if (nErr) {
		lpFile->nPos = 0;
		if (!lpFile->nErr) lpFile->nErr = nErr;
		SetErrorFlags(ERRF_FILE | nErr);
	}
	return lpFile->nPos;
}
