/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fsettime.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall FSetTime(LPFILEIO lpFile, INT32 nMode, LPSYSTEMTIME lpFileTime) {
LPFILETIME		pCreationTime, pLastAccessTime, pLastWriteTime;
FILETIME		LocFT, FT;
INT32			nErr;
BOOL			bOK;

	if (!lpFile) return FALSE;
	bOK = SystemTimeToFileTime(lpFileTime, &LocFT);
	if (bOK) {
		bOK = LocalFileTimeToFileTime(&LocFT, &FT);
		if (bOK) {
			pCreationTime = pLastAccessTime = pLastWriteTime = NULL;
			if (nMode & FT_CREATION) pCreationTime = &FT;
			if (nMode & FT_LASTACCESS) pLastAccessTime = &FT;
			if (nMode & FT_LASTWRITE) pLastWriteTime = &FT;
			bOK = SetFileTime(lpFile->hFile, pCreationTime, pLastAccessTime, pLastWriteTime);
		}
	}
	if (bOK) nErr = 0;
	else {
		nErr = GetLastError();;
		if (!lpFile->nErr) lpFile->nErr = nErr;
		SetErrorFlags(ERRF_FILE | nErr);
	}
	return nErr;
}
