/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fsplit.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall FSplit(BOOL bBackslash, LPSTR lpFolder, LPSTR lpName, LPSTR lpPath) {
char	cBuf[MAX_WORKPATH];
INT32	nPos, cpr, nLen, nRet;

	nRet = 0;
	nLen = StrLen(lpPath);
	if (nLen && (nLen < MAX_WORKPATH)) {
		nRet = 1;
		StrCpy(cBuf, lpPath);
	}
	if (lpFolder) lpFolder[0] = 0;
	if (lpName) lpName[0] = 0;
	if (nRet) {
		nPos = 1 + ChrInStrRev(cBuf, '\\', MAX_SIGNED32, FALSE);
		StrCpy(lpName, &cBuf[nPos]);
		if (nPos) {
			nRet = 2;
			if (!bBackslash) {
				cBuf[nPos] = '\0';
				cpr = CheckFolderName(cBuf);
				if ((cpr == CPR_VALID) || (cpr < CPR_COMPUTER)) nPos--;
			}
			cBuf[nPos] = '\0';
			StrCpy(lpFolder, cBuf);
		}
	}
	return nRet;
}
