/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - fwrite.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
UINT32 __stdcall FWrite(LPFILEIO lpFile, LPVOID lpBuffer, UINT32 nNumberOfBytesToWrite) {
INT32	nErr;
UINT32	nRetVal;

	if (!lpFile) return 0;
	nRetVal = 0;
	if ((lpFile->hFile == INVALID_HANDLE_VALUE)) nErr = ERROR_INVALID_HANDLE;
	else {
		if (!WriteFile(lpFile->hFile, lpBuffer, nNumberOfBytesToWrite, &nRetVal, NULL)) {
			nErr = GetLastError();
			nRetVal = 0;
		}
		else {
			nErr = (nRetVal == nNumberOfBytesToWrite) ? NO_ERROR : ERROR_WRITE_FAULT;
		}
		lpFile->nPos += nRetVal;
		if (lpFile->nPos > lpFile->nSize) lpFile->nSize = lpFile->nPos;
		if (nRetVal && lpFile->pIOProc) lpFile->pIOProc(FCBM_WRITE, lpFile, lpBuffer, nRetVal);
	}
	if (nErr) {
		if (!lpFile->nErr) lpFile->nErr = nErr;
		SetErrorFlags(ERRF_FILE | nErr);
	}
	return nRetVal;
}
