/********************************************************************
 * Copyright (c) 2011-19 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - fasttimer.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <mmsystem.h>

#pragma comment(lib, "winmm.lib")

#pragma pack(push, 1)

typedef struct tagFASTTIMER	FASTTIMER, *LPFASTTIMER;
typedef struct tagFASTTIMER {
	LPFASTTIMER						pNext;
	UINT32							nID;
	LPUINT32						pCounter;
	INT32							nEventBase;
	INT32							nEventCounter;
	HANDLE							hEvent;
	INT32							nProcBase;
	INT32							nProcCounter;
	FASTTIMERPROC					pProc;
	LPVOID							pParam;
} FASTTIMER, *LPFASTTIMER;

#pragma pack(pop)

static LPFASTTIMER					m_pTimer		= NULL;
static INT32						m_nWinTimerID	= 0;
volatile static UINT32				m_nTimerID		= 0;

static void __stdcall FastTimerProc(UINT32 uID, UINT32 uMsg, DWORD dwUser, DWORD dw1, DWORD dw2) {
LPFASTTIMER			pTimer;

	pTimer = m_pTimer;
	while (pTimer) {
		if (pTimer->pCounter) (*pTimer->pCounter)++;
		if (pTimer->nEventBase) {
			pTimer->nEventCounter--;
			if (!pTimer->nEventCounter) {
				pTimer->nEventCounter = pTimer->nEventBase;
				SetEvent(pTimer->hEvent);
			}
		}
		if (pTimer->nProcBase) {
			pTimer->nProcCounter--;
			if (!pTimer->nProcCounter) {
				pTimer->nProcCounter = pTimer->nProcBase;
				pTimer->pProc(pTimer->pParam);
			}
		}
		pTimer = pTimer->pNext;
	}
}
// **********************************************************************************
UINT32 __stdcall FastTimer_Init(LPUINT32 lpTimerValue, INT32 nEventBase, HANDLE hEvent, INT32 nProcBase, FASTTIMERPROC lpProc, LPVOID lpParam) {
LPFASTTIMER		pTimer;

	pTimer = GetMem(GMM_CLEAR, sizeof(FASTTIMER));
	LockThread(_TIME_LOCK);
	pTimer->nID = ++m_nTimerID;
	UnLockThread(_TIME_LOCK);
	pTimer->pCounter = lpTimerValue;
	if (nEventBase && hEvent) {
		pTimer->nEventBase = pTimer->nEventCounter = nEventBase;
		pTimer->hEvent = hEvent;
	}
	if (nProcBase && lpProc) {
		pTimer->nProcBase = pTimer->nProcCounter = nProcBase;
		pTimer->pProc = lpProc;
		pTimer->pParam = lpParam;
	}
	if (!m_pTimer) {
		timeBeginPeriod(1);
		m_nWinTimerID = timeSetEvent(1, 0, FastTimerProc, 0, TIME_PERIODIC);
	}
	m_pTimer = Chain_AddItem(pTimer, m_pTimer);
	return pTimer->nID;
}
// **********************************************************************************
void __stdcall FastTimer_Done(UINT32 nTimer) {
LPFASTTIMER		pTimer;

	pTimer = Chain_GetItem(nTimer, m_pTimer);
	if (pTimer) {
		m_pTimer = Chain_DelItem(nTimer, m_pTimer);
		pTimer->pCounter = NULL;
		pTimer->nEventBase = pTimer->nProcBase =0;
		FreeMem(pTimer);
		if (!m_pTimer) {
			timeKillEvent(m_nWinTimerID);
			m_nWinTimerID = 0;
			timeEndPeriod(1);
		}
	}
}
