/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - filesort.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

// **********************************************************************************
static INT32 CALLBACK Sort_CmpProc(LPSORTINFO lpSort, LPSTR lpListStr, LPSTR lpFindStr, LPFILEINFO lpFindInfo) {
LPFILEINFO		pInfo;
INT32			nRet, nAttr1, nAttr2;

	pInfo = (LPFILEINFO) (lpListStr - sizeof(FILEINFO));
	nAttr1 = pInfo->nAttr & FA_DIRECTORY;
	nAttr2 = lpFindInfo->nAttr & FA_DIRECTORY;
	if (nAttr1 == nAttr2) {
		nRet = 0;
		if (nAttr1) {
			if (StrCmp(lpListStr, STR_PARENTDIR) == 0) {
				nRet--;
			}
			if (StrCmp(lpFindStr, STR_PARENTDIR) == 0) {
				nRet++;
			}
		}
		if (!nRet) {
			nRet = FNameCmp(lpListStr, lpFindStr);
		}
	}
	else {
		nRet = nAttr1 ? -1 : 1;
	}
	return nRet;
}
// **********************************************************************************
BOOL __stdcall FSort_Init(LPSORTINFO lpSort) {

	return Sort_Init(lpSort, 64, 2048, sizeof(FILEINFO), Sort_CmpProc);
}
// **********************************************************************************
INT32 __stdcall FSort_Fill(LPSORTINFO lpSort, LPSTR lpFolder, LPSTR lpMask, BOOL bFolder, BOOL bParent) {
WIN32_FIND_DATA		fd;
HANDLE				hFind;
FILETIME			ft;
FILEINFO			fi;
char				cBuf[MAX_PATH];
LPSTR				pCurMask;
INT32				nLen;
BOOL				bOK, bIsCurrent, bIsParent;

	StrXCpy(cBuf, lpFolder, STR_ANYFILE);
	bIsCurrent = bIsParent = FALSE;
	hFind = FindFirstFile(cBuf, &fd);
	MemClr(&fi, sizeof(FILEINFO));
	if (hFind != INVALID_HANDLE_VALUE) {
		do {
			if (!(fd.dwFileAttributes & FA_UNKNOWN)) {
				bOK = (fd.dwFileAttributes & FA_DIRECTORY) && bFolder;
				if (bOK) {
					if (!bIsCurrent) {
						if (bIsCurrent = StrCmp(fd.cFileName, STR_CURRENTDIR) == 0) bOK = FALSE;
					}
					if (!bIsParent) {
						bIsParent = StrCmp(fd.cFileName, STR_PARENTDIR) == 0;
					}
				}
				else {
					pCurMask = lpMask;
					while ((nLen = StrLen(pCurMask)) && !bOK) {
						bOK = FNameMask(fd.cFileName, pCurMask);
						pCurMask += nLen + 1;
					}
				}
				if (bOK) {
					FileTimeToLocalFileTime(&fd.ftLastWriteTime, &ft);
					FileTimeToSystemTime(&ft, &fi.Time);
					fi.nSizeLo = fd.nFileSizeLow;
					fi.nSizeHi = fd.nFileSizeHigh;
					fi.nAttr = fd.dwFileAttributes & FA_MASK;
					if (!fi.nAttr) fi.nAttr = FA_NORMAL;
					Sort_Add(lpSort, fd.cFileName, &fi, TRUE, 0);
				}
			}
		} while (FindNextFile(hFind, &fd) != 0);
		FindClose(hFind);
	}
	if (bParent && !bIsParent) {
		MemClr(&fi, sizeof(FILEINFO));
		fi.nAttr = FA_DIRECTORY;
		GetFTime(lpFolder, FT_LASTWRITE, &fi.Time);
		Sort_Add(lpSort, STR_PARENTDIR, &fi, TRUE, 0);
	}
	return lpSort->nCount;
}
