/********************************************************************
 * Copyright (c) 2011-20 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - findfilex.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
HANDLE __stdcall FindFirstFileX(LPSTR lpFolder, LPSTR lpMask, LPWIN32_FIND_DATA lpFD) {
char		cBuf[MAX_WORKPATH];
INT32		nLen, nMask;
HANDLE		hFind;

	nLen = StrCpy(cBuf, lpFolder);
	nMask = StrCat(cBuf, lpMask);
	if (nMask >= MAX_PATH) {
		nMask -= nLen;
		cBuf[nLen] = 0;
		GetShortPathNameX(cBuf, cBuf, MAX_PATH - nMask);
		StrCat(cBuf, lpMask);
	}
	hFind = FindFirstFile(cBuf, lpFD);
	return hFind;
}
// **********************************************************************************
LPSTR __stdcall GetFindFileName(LPSTR lpFolder, LPWIN32_FIND_DATA lpFD) {
char	cBuf[MAX_WORKPATH];
LPSTR	pName;
INT32	nLen, nXLen;

	nLen = StrCpy(cBuf, lpFolder);
	nXLen = StrCat(cBuf, lpFD->cFileName);
	if (nXLen >= MAX_PATH) {
		nXLen -= nLen;
		cBuf[nLen] = 0;
		nLen = GetShortPathNameX(cBuf, cBuf, MAX_PATH - nXLen);
		StrCat(cBuf, lpFD->cFileName);
	}
	pName = PathExists(cBuf) ? lpFD->cFileName : lpFD->cAlternateFileName;
	return pName;
}
