/********************************************************************
 * Copyright (c) 2011-19 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - findprocess.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <tlhelp32.h>
// **********************************************************************************
UINT32 __stdcall FindProcess(UINT32 nOwnID, LPSTR lpProcessName, LPHANDLE lpHandle) {
BOOL			bOK;
UINT32			nRet;
PROCESSENTRY32	ProcEntry;
HANDLE			hSnapshot;

	nRet = 0;
	MemClr(&ProcEntry, sizeof(PROCESSENTRY32));
    ProcEntry.dwSize = sizeof(PROCESSENTRY32);
    hSnapshot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);
	if (hSnapshot != INVALID_HANDLE_VALUE) {
		bOK = Process32First(hSnapshot, &ProcEntry);
		do {
			if (bOK) {
				if (StrICmp(ProcEntry.szExeFile, lpProcessName) == 0) {
					if (ProcEntry.th32ProcessID != nOwnID) nRet = ProcEntry.th32ProcessID;
				}
				if (!nRet) bOK = Process32Next(hSnapshot, &ProcEntry);
			}
		} while (bOK && !nRet);
		CloseHandle(hSnapshot);
	}
	if (nRet && lpHandle) {
		*lpHandle = OpenProcess(PROCESS_ALL_ACCESS, FALSE, nRet);
	}
    return nRet;
}
