/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getbordersize.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
void __stdcall GetBorderSize(HWND hWnd, LPINT32 lpToolHeight, LPINT32 lpStatusHeight, LPINT32 lpWidth, LPINT32 lpHeight) {
RECT	rAdjust, rClient;
UINT32	nStyle, nEx;
INT32	nTool, nStatus;
BOOL	bMenu, bNormal;

	bMenu = GetMenu(hWnd) ? TRUE : FALSE;
	nStyle = GetWindowLong(hWnd, GWL_STYLE);
	nEx = GetWindowLong(hWnd, GWL_EXSTYLE);
	MemClr(&rAdjust, sizeof(RECT));
	AdjustWindowRectEx(&rAdjust, nStyle, bMenu, nEx);
	bNormal = GetClientSize(hWnd, &rClient);
	nTool = nStatus = 0;
	if (lpToolHeight) {
		if (bNormal) *lpToolHeight = GetWindowHeight(hWnd, IDC_TOOLBAR);
		nTool = *lpToolHeight;
	}
	if (lpStatusHeight) {
		if (bNormal) *lpStatusHeight = GetWindowHeight(hWnd, IDC_STATUSBAR);
		nStatus = *lpStatusHeight;
	}
	if (lpWidth) *lpWidth = rAdjust.right - rAdjust.left;
	if (lpHeight) *lpHeight = rAdjust.bottom - rAdjust.top + nStatus + nTool;
}
