/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getfinfo.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall GetFInfo(LPSTR lpFileName, LPFILEINFO lpFileInfo) {
WIN32_FILE_ATTRIBUTE_DATA	fd;
FILETIME					LocFT;
INT32						nErr;
char						cName[MAX_PATH];

	MemClr(lpFileInfo, sizeof(FILEINFO));
	if (StrCpy(cName, lpFileName)) {
		lpFileInfo->nType = CheckFolderName(cName);
		FormatFolder(cName, lpFileInfo->nType >= CPR_ROOT);
		if (GetFileAttributesEx(cName, GetFileExInfoStandard, &fd)) {
			if (fd.dwFileAttributes & FA_UNKNOWN) nErr = ERROR_FILE_NOT_FOUND;
			else {
				FileTimeToLocalFileTime(&fd.ftLastWriteTime, &LocFT);
				FileTimeToSystemTime(&LocFT, &lpFileInfo->Time);
				lpFileInfo->nSizeLo = fd.nFileSizeLow;
				lpFileInfo->nSizeHi = fd.nFileSizeHigh;
				lpFileInfo->nAttr = fd.dwFileAttributes;
				nErr = 0;
			}
		}
		else nErr = GetLastError();
	}
	else nErr = ERROR_FILE_NOT_FOUND;
	if (lpFileInfo->nIOErr = nErr) SetErrorFlags(ERRF_FILE | nErr);
	return nErr;
}
