/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getfsize.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT64 __stdcall GetFSize(LPSTR lpFileName, LPINT32 lpError) {
WIN32_FILE_ATTRIBUTE_DATA	fd;
ANYVALUE					nRet;
INT32						nErr;

	nRet.u64 = 0;
	if (GetFileAttributesEx(lpFileName, GetFileExInfoStandard, &fd)) {
		if (fd.dwFileAttributes & (FA_DIRECTORY | FA_UNKNOWN)) nErr = ERROR_FILE_NOT_FOUND;
		else {
			nRet.u32lo = fd.nFileSizeLow;
			nRet.u32hi = fd.nFileSizeHigh;
			nErr = 0;
		}
	}
	else nErr = GetLastError();
	if (nErr) SetErrorFlags(ERRF_FILE | nErr);
	if (lpError) *lpError = nErr;
	return nRet.u64;
}
