/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getftime.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall GetFTime(LPSTR lpFileName, INT32 nMode, LPSYSTEMTIME lpFileTime) {
WIN32_FILE_ATTRIBUTE_DATA	fd;
LPFILETIME					lpFT;
FILETIME					LocFT;
INT32						nErr, nLen;
char						cName[MAX_PATH];

	MemClr(lpFileTime, sizeof(SYSTEMTIME));
	nLen = StrCpy(cName, lpFileName);
	if (nLen) {
		FormatFolder(cName, CheckFolderName(cName) >= CPR_ROOT);
		if (GetFileAttributesEx(cName, GetFileExInfoStandard, &fd)) {
			if (fd.dwFileAttributes & FA_UNKNOWN) nErr = ERROR_FILE_NOT_FOUND;
			else {
				if (nMode == FT_CREATION) lpFT = &fd.ftCreationTime;
				else if (nMode == FT_LASTACCESS) lpFT = &fd.ftLastAccessTime;
				else lpFT = &fd.ftLastWriteTime;
				FileTimeToLocalFileTime(lpFT, &LocFT);
				FileTimeToSystemTime(&LocFT, lpFileTime);
				nErr = 0;
			}
		}
		else nErr = GetLastError();
	}
	else nErr = ERROR_FILE_NOT_FOUND;
	if (nErr) SetErrorFlags(ERRF_FILE | nErr);
	return nErr;
}
