/********************************************************************
 * Copyright (c) 2011-21 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getparamstr.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
LPSTR __stdcall GetParamStrA(LPSTR lpDst, LPSTR lpCmdLine, INT32 nDstSize, LPINT32 lpLen) {
BOOL		inDoubleQuote;
INT32		nLen;
char		c;

	nLen = inDoubleQuote = 0;
	if (lpDst && (nDstSize > 0)) {
		if (lpCmdLine) {
			while (*lpCmdLine == ' ') {
				lpCmdLine++;
			}
			c = *lpCmdLine;
			while (((c > ' ') || (c && inDoubleQuote)) && (nLen < nDstSize)) {
				if (c == '\"') {
					inDoubleQuote = !inDoubleQuote;
				}
				else {
					lpDst[nLen++] = c;
				}
				c = *(++lpCmdLine);
			}
			if (nLen == nDstSize) nLen--;
		}
		lpDst[nLen] = 0;
	}
	if (lpLen) *lpLen = nLen;
	return lpCmdLine;
}
// **********************************************************************************
LPWSTR __stdcall GetParamStrW(LPWSTR lpDst, LPWSTR lpCmdLine, INT32 nDstSize, LPINT32 lpLen) {
BOOL		inDoubleQuote;
INT32		nLen;
WCHAR		c;

	nLen = inDoubleQuote = 0;
	if (lpDst && (nDstSize > 0)) {
		if (lpCmdLine) {
			while (*lpCmdLine == ' ') {
				lpCmdLine++;
			}
			c = *lpCmdLine;
			while (((c > ' ') || (c && inDoubleQuote)) && (nLen < nDstSize)) {
				if (c == '\"') {
					inDoubleQuote = !inDoubleQuote;
				}
				else {
					lpDst[nLen++] = c;
				}
				c = *(++lpCmdLine);
			}
			if (nLen == nDstSize) nLen--;
		}
		lpDst[nLen] = 0;
	}
	if (lpLen) *lpLen = nLen;
	return lpCmdLine;
}
