/********************************************************************
 * Copyright (c) 2011-20 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getshortpathnamex.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall GetShortPathNameX(LPSTR lpLongName, LPSTR lpShortName, INT32 nMaxSize) {
char	cBuf[MAX_WORKPATH], cShort[MAX_PATH];
INT32	nPos, nMax, nLen, nRet;
BOOL	bRdy, bFolder;

	if (!lpShortName) return 0;
	if (nMaxSize > MAX_PATH) {
		nMaxSize = MAX_PATH;
	}
	nLen = StrLen(lpLongName);
	if (nLen < nMaxSize) {
		StrCpy(lpShortName, lpLongName);
		return nLen;
	}
	if (nLen < MAX_WORKPATH) {
		nLen = StrCpy(cBuf, lpLongName);
	}
	lpShortName[0] = 0;
	if (nLen >= MAX_WORKPATH) return 0;
	if (cBuf[nLen - 1] == '\\') {
		cBuf[nLen--] = 0;
		bFolder = TRUE;
	}
	else {
		bFolder = FALSE;
	}
	nMax = nLen;
	bRdy = FALSE;
	nRet = 0;
	do {
		nPos = ChrInStrRev(cBuf, '\\', nMax, FALSE);
		if (nPos > 0) {
			if (nPos < nMaxSize) {
				cBuf[nPos] = 0;
				nLen = GetShortPathName(cBuf, cShort, nMaxSize);
				cBuf[nPos] = '\\';
				if (!nLen || (nLen >= nPos)) {
					bRdy = TRUE;
				}
				else {
					StrCpy(cBuf, cShort);
					nLen = StrCat(cBuf, &cBuf[nPos]);
					nMax = nLen;
					if (nLen < nMaxSize) {
						bRdy = TRUE;
						nRet = StrCpy(lpShortName, cBuf);
						if (bFolder) {
							if (nRet < (nMaxSize - 1)) {
								lpShortName[nRet++] = '\\';
								lpShortName[nRet] = 0;
							}
							else {
								bRdy = FALSE;
							}
						}
					}
				}

			}
			else {
				nMax = nPos - 1;
			}

		}
		else {
			bRdy = TRUE;
		}
	} while (!bRdy);
	return nRet;
}
