/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - getspecialfolder.c									*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <shlobj.h>
#include <objbase.h>
#pragma comment(lib, "ole32.lib")
#pragma comment(lib, "shfolder.lib")
// **********************************************************************************
INT32 __stdcall GetSpecialFolder(INT32 nFolder, LPSTR lpFolder) {
LPITEMIDLIST	pidl;
char			cBuf[MAX_PATH];
HRESULT			hRes;
BOOL			bCoInit;
INT32			nRet;

	hRes = SHGetFolderPath(NULL, nFolder, NULL, 0, cBuf);
	if (hRes != S_OK) {
		bCoInit = COM_Init();
		hRes = SHGetSpecialFolderLocation(NULL, nFolder, &pidl);
		if (hRes == S_OK) {
			SHGetPathFromIDList(pidl, cBuf);
			CoTaskMemFree(pidl);
		}
		COM_Done(bCoInit);
	}
	if (lpFolder) {
		if (hRes == S_OK) {
			StrCpy(lpFolder, cBuf);
			nRet = FormatFolder(lpFolder, TRUE);
		}
		else nRet = lpFolder[0] = 0;
	}
	else nRet = 0;
	return nRet;
}

