/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - getuserinfo.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#define SECURITY_WIN32
#include <security.h>
#include <secext.h>
// **********************************************************************************
// from Windows 2000
// #pragma comment(lib, "secur32.lib")
//	GetUserNameEx(NameSamCompatible, cUser, &nSize);
//	if(StrInStr(cUser, g_SKDPInfo.cName, 0, TRUE) == 0)	GetUserName(cUser, &nSize);
// **********************************************************************************
typedef void (__stdcall* USERNAMEEXPROC)(INT32 NameFormat, LPSTR lpUser, LPINT32 lpSize);
//*******************************************************************
void __stdcall GetUserInfo(LPUSERINFO lpUserInfo) {
#define MAX_NAMESIZE	256
USERNAMEEXPROC		pProc;
HANDLE				hLib;
char				cUser[MAX_NAMESIZE];
char				cComp[MAX_NAMESIZE];
INT32				n;

	n = MAX_NAMESIZE;
	GetComputerName(cComp, &n);
	TrimCpyN(lpUserInfo->cPCName, cComp, MAX_PCNAMESIZE, TSM_BOTH);
	hLib = LoadLibrary("secur32.dll");
	cUser[0] = 0;
	if (hLib) {
		pProc = (USERNAMEEXPROC) GetProcAddress(hLib, "GetUserNameExA");
		if (pProc) {
			n = MAX_NAMESIZE;
			pProc(NameSamCompatible, cUser, &n);
			if (StrInStr(cUser, cComp, 0, TRUE) == 0) cUser[0] = 0;
		}
		FreeLibrary(hLib);
	}
	if (!cUser[0]) {
		n = MAX_NAMESIZE;
		GetUserName(cUser, &n);
	}
	n = ChrInStr(cUser, '\\', 0, MAX_SIGNED32, FALSE);
	if (n >= 0) {
		cUser[n] = 0;
		TrimCpyN(lpUserInfo->cDomainName, cUser, MAX_DOMAINNAMESIZE, TSM_BOTH);
	}
	n++;
	TrimCpyN(lpUserInfo->cUserName, &cUser[n], MAX_USERNAMESIZE, TSM_BOTH);
}
