/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - killprocess.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
//*******************************************************************
static BOOL					m_bActive				= FALSE;
static UINT32				m_nTimeOut				= 0;
static HANDLE				m_hThread				= NULL;
// **********************************************************************************
static INT32 __stdcall pKillProcessThreadProc(LPVOID lpVoid) {
INT32		nRet;
UINT32		nStart, nDelta;

	__try {
		nRet = 0;
		nStart = GetTickCount();
		do {
			Sleep(0);
			nDelta = GetTickCount() - nStart;
			if (nDelta >= m_nTimeOut) {
#ifdef _DEBUG
	DbgStrPrint("Process killed.\r\n");
#endif	//	_DEBUG
				exit(-1);
			} 
		} while (m_bActive);
	}
	__except(EXCEPTION_EXECUTE_HANDLER) {
		nRet = GetExceptionCode();
	} // end of try - except
	m_hThread = NULL;
	return nRet;
}
// **********************************************************************************
BOOL __stdcall KillProcess_Start(UINT32 nTimeOut) {
BOOL	bRet;

	m_bActive = TRUE;
	m_nTimeOut = nTimeOut;
	m_hThread = SimpleThread(pKillProcessThreadProc, NULL);
	bRet = m_hThread ? TRUE : FALSE;
	return bRet;
}
// **********************************************************************************
void __cdecl KillProcess_Break() {

	m_bActive = FALSE;
	if (m_hThread) {
		WaitForZero(&m_hThread, 1000);
	}
	if (m_hThread) {
		TerminateThread(m_hThread, -1);
		m_hThread = NULL;
	}
}
