/********************************************************************
 * Copyright (c) 2011-21 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - lbunselect.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

#define SUBCLASSID		'SKSC'
#pragma pack(push, 1)
typedef struct tagMYUSERDATA {
	INT32				nID;
	INT32				nListID;
	HWND				hDlg;
	WNDPROC				WndProc;
} MYUSERDATA, *LPMYUSERDATA;
#pragma pack(pop)
// **********************************************************************************
static LRESULT __stdcall WndProcListBox(HWND hWnd, UINT32 nMsg, WPARAM wParam, LPARAM lParam) {
LPMYUSERDATA	pData;
LRESULT			lRet;
INT32			nPrev, nAct, nFromPt;
HWND			hBox;
POINT			pt;

	pData = (LPMYUSERDATA) GetWindowLong(hWnd, GWL_USERDATA);
	lRet = FALSE;
	if (pData->nID == SUBCLASSID) {
		if (nMsg == WM_LBUTTONDOWN) {
			SplitInt32((INT32) lParam, &pt.x, &pt.y);
			nPrev = SendDlgItemMessage(pData->hDlg, pData->nListID, LB_GETCURSEL, 0, 0);
		}
		lRet = CallWindowProc(pData->WndProc, hWnd, nMsg, wParam, lParam);
		if (nMsg == WM_LBUTTONDOWN) {
			hBox = GetDlgItem(pData->hDlg, pData->nListID);
			nAct = SendDlgItemMessage(pData->hDlg, pData->nListID, LB_GETCURSEL, 0, 0);
			ClientToScreen(hBox, &pt);
			nFromPt = LBItemFromPt(hBox, pt, FALSE);
			if ((nAct == nPrev) || (nFromPt < 0)) {
				SendDlgItemMessage(pData->hDlg, pData->nListID, LB_SETCURSEL, -1, 0);
				nAct = -1;
			}
			if (nAct != nPrev) SendMessage(pData->hDlg, WM_SK_LISTSEL, pData->nListID, nAct);
		}
	}
	return lRet;
}
// **********************************************************************************
BOOL __stdcall LB_UnSelect_Init(HWND hDlg, INT32 nListBoxID) {
LPMYUSERDATA	pData;
HWND			hListBox;
UINT32			nBox;

	if (!IsWindow(hDlg)) return FALSE;
	hListBox = GetDlgItem(hDlg, nListBoxID);
	if (!IsWindow(hListBox)) return FALSE;
	pData = GetMem(GMM_CLEAR, sizeof(MYUSERDATA));
	if (!pData) return FALSE;
	nBox = SetWindowLong(hListBox, GWL_USERDATA, (LONG) pData);
	if (nBox) {
		SetWindowLong(hListBox, GWL_USERDATA, (LONG) nBox);
		FreeMem(pData);
		return FALSE;
	}
	pData->nID = SUBCLASSID;
	pData->hDlg = hDlg;
	pData->nListID = nListBoxID;
	pData->WndProc = (WNDPROC) SetWindowLong(hListBox, GWLP_WNDPROC, (LONG) WndProcListBox);
	return TRUE;
}
// **********************************************************************************
BOOL __stdcall LB_UnSelect_Done(HWND hDlg, INT32 nListBoxID) {
LPMYUSERDATA	pData;
HWND			hListBox;

	if (!IsWindow(hDlg)) return FALSE;
	hListBox = GetDlgItem(hDlg, nListBoxID);
	if (!IsWindow(hListBox)) return FALSE;
	pData = (LPMYUSERDATA) GetWindowLong(hListBox, GWL_USERDATA);
	if (!pData || (pData->nID != SUBCLASSID) || (pData->nListID != nListBoxID)) return FALSE;
	SetWindowLong(hListBox, GWLP_WNDPROC, (LONG) pData->WndProc);
	SetWindowLong(hListBox, GWL_USERDATA, (LONG) 0);
	FreeMem(pData);
	return TRUE;
}
